"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRuntimeConfig = void 0;
const signature_v4_multi_region_1 = require("@aws-sdk/signature-v4-multi-region");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const url_parser_1 = require("@aws-sdk/url-parser");
const util_base64_1 = require("@aws-sdk/util-base64");
const util_stream_1 = require("@aws-sdk/util-stream");
const util_utf8_1 = require("@aws-sdk/util-utf8");
const endpointResolver_1 = require("./endpoint/endpointResolver");
const getRuntimeConfig = (config) => ({
    apiVersion: "2006-03-01",
    base64Decoder: config?.base64Decoder ?? util_base64_1.fromBase64,
    base64Encoder: config?.base64Encoder ?? util_base64_1.toBase64,
    disableHostPrefix: config?.disableHostPrefix ?? false,
    endpointProvider: config?.endpointProvider ?? endpointResolver_1.defaultEndpointResolver,
    getAwsChunkedEncodingStream: config?.getAwsChunkedEncodingStream ?? util_stream_1.getAwsChunkedEncodingStream,
    logger: config?.logger ?? new smithy_client_1.NoOpLogger(),
    sdkStreamMixin: config?.sdkStreamMixin ?? util_stream_1.sdkStreamMixin,
    serviceId: config?.serviceId ?? "S3",
    signerConstructor: config?.signerConstructor ?? signature_v4_multi_region_1.SignatureV4MultiRegion,
    signingEscapePath: config?.signingEscapePath ?? false,
    urlParser: config?.urlParser ?? url_parser_1.parseUrl,
    useArnRegion: config?.useArnRegion ?? false,
    utf8Decoder: config?.utf8Decoder ?? util_utf8_1.fromUtf8,
    utf8Encoder: config?.utf8Encoder ?? util_utf8_1.toUtf8,
});
exports.getRuntimeConfig = getRuntimeConfig;
