"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReceiveMessagePlugin = exports.receiveMessageMiddlewareOptions = exports.receiveMessageMiddleware = void 0;
const util_hex_encoding_1 = require("@smithy/util-hex-encoding");
const util_utf8_1 = require("@smithy/util-utf8");
function receiveMessageMiddleware(options) {
    return (next) => async (args) => {
        const resp = await next({ ...args });
        const output = resp.output;
        const messageIds = [];
        if (output.Messages !== undefined) {
            for (const message of output.Messages) {
                const md5 = message.MD5OfBody;
                const hash = new options.md5();
                hash.update((0, util_utf8_1.toUint8Array)(message.Body || ""));
                if (md5 !== (0, util_hex_encoding_1.toHex)(await hash.digest())) {
                    messageIds.push(message.MessageId);
                }
            }
        }
        if (messageIds.length > 0) {
            throw new Error("Invalid MD5 checksum on messages: " + messageIds.join(", "));
        }
        return resp;
    };
}
exports.receiveMessageMiddleware = receiveMessageMiddleware;
exports.receiveMessageMiddlewareOptions = {
    step: "initialize",
    tags: ["VALIDATE_BODY_MD5"],
    name: "receiveMessageMiddleware",
    override: true,
};
const getReceiveMessagePlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add(receiveMessageMiddleware(config), exports.receiveMessageMiddlewareOptions);
    },
});
exports.getReceiveMessagePlugin = getReceiveMessagePlugin;
