"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSendMessageBatchPlugin = exports.sendMessageBatchMiddlewareOptions = exports.sendMessageBatchMiddleware = void 0;
const util_hex_encoding_1 = require("@smithy/util-hex-encoding");
const util_utf8_1 = require("@smithy/util-utf8");
const sendMessageBatchMiddleware = (options) => (next) => async (args) => {
    const resp = await next({ ...args });
    const output = resp.output;
    const messageIds = [];
    const entries = {};
    if (output.Successful !== undefined) {
        for (const entry of output.Successful) {
            if (entry.Id !== undefined) {
                entries[entry.Id] = entry;
            }
        }
    }
    for (const entry of args.input.Entries) {
        if (entries[entry.Id]) {
            const md5 = entries[entry.Id].MD5OfMessageBody;
            const hash = new options.md5();
            hash.update((0, util_utf8_1.toUint8Array)(entry.MessageBody || ""));
            if (md5 !== (0, util_hex_encoding_1.toHex)(await hash.digest())) {
                messageIds.push(entries[entry.Id].MessageId);
            }
        }
    }
    if (messageIds.length > 0) {
        throw new Error("Invalid MD5 checksum on messages: " + messageIds.join(", "));
    }
    return resp;
};
exports.sendMessageBatchMiddleware = sendMessageBatchMiddleware;
exports.sendMessageBatchMiddlewareOptions = {
    step: "initialize",
    tags: ["VALIDATE_BODY_MD5"],
    name: "sendMessageBatchMiddleware",
    override: true,
};
const getSendMessageBatchPlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add((0, exports.sendMessageBatchMiddleware)(config), exports.sendMessageBatchMiddlewareOptions);
    },
});
exports.getSendMessageBatchPlugin = getSendMessageBatchPlugin;
