"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSendMessagePlugin = exports.sendMessageMiddlewareOptions = exports.sendMessageMiddleware = void 0;
const util_hex_encoding_1 = require("@smithy/util-hex-encoding");
const util_utf8_1 = require("@smithy/util-utf8");
const sendMessageMiddleware = (options) => (next) => async (args) => {
    const resp = await next({ ...args });
    const output = resp.output;
    const hash = new options.md5();
    hash.update((0, util_utf8_1.toUint8Array)(args.input.MessageBody || ""));
    if (output.MD5OfMessageBody !== (0, util_hex_encoding_1.toHex)(await hash.digest())) {
        throw new Error("InvalidChecksumError");
    }
    return resp;
};
exports.sendMessageMiddleware = sendMessageMiddleware;
exports.sendMessageMiddlewareOptions = {
    step: "initialize",
    tags: ["VALIDATE_BODY_MD5"],
    name: "sendMessageMiddleware",
    override: true,
};
const getSendMessagePlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add((0, exports.sendMessageMiddleware)(config), exports.sendMessageMiddlewareOptions);
    },
});
exports.getSendMessagePlugin = getSendMessagePlugin;
