"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromUtf8 = exports.toUtf8 = void 0;
function isValidUtf8(data) {
    const toStringAndBack = Buffer.from(Buffer.from(data).toString("utf8"), "utf8");
    return Buffer.compare(Buffer.from(data), toStringAndBack) === 0;
}
function toUtf8(str) {
    // Browser and future nodejs (https://github.com/nodejs/node/issues/20365)
    if (typeof TextEncoder !== "undefined") {
        return new TextEncoder().encode(str);
    }
    // Use Buffer hack instead of nodejs util.TextEncoder to ensure
    // webpack does not bundle the util module for browsers.
    return new Uint8Array(Buffer.from(str, "utf8"));
}
exports.toUtf8 = toUtf8;
function fromUtf8(data) {
    // Browser and future nodejs (https://github.com/nodejs/node/issues/20365)
    if (typeof TextDecoder !== "undefined") {
        return new TextDecoder("utf-8", { fatal: true }).decode(data);
    }
    // Use Buffer hack instead of nodejs util.TextDecoder to ensure
    // webpack does not bundle the util module for browsers.
    // Buffer.toString has no fatal option
    if (!isValidUtf8(data)) {
        throw new Error("Invalid UTF8 data");
    }
    return Buffer.from(data).toString("utf8");
}
exports.fromUtf8 = fromUtf8;
//# sourceMappingURL=utf8.js.map