module.exports = "\"use strict\";\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __name = (target, value) => __defProp(target, \"name\", { value, configurable: true });\nvar __export = (target, all) => {\n  for (var name in all)\n    __defProp(target, name, { get: all[name], enumerable: true });\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toCommonJS = (mod) => __copyProps(__defProp({}, \"__esModule\", { value: true }), mod);\n\n// src/primitives/events.js\nvar events_exports = {};\n__export(events_exports, {\n  Event: () => Event,\n  EventTarget: () => EventTarget,\n  FetchEvent: () => FetchEvent,\n  PromiseRejectionEvent: () => PromiseRejectionEvent\n});\nmodule.exports = __toCommonJS(events_exports);\n\n// <define:process>\nvar define_process_default = { env: {}, versions: { node: \"16.6.0\" } };\n\n// ../../node_modules/.pnpm/event-target-shim@6.0.2/node_modules/event-target-shim/index.mjs\nfunction assertType(condition, message, ...args) {\n  if (!condition) {\n    throw new TypeError(format(message, args));\n  }\n}\n__name(assertType, \"assertType\");\nfunction format(message, args) {\n  let i = 0;\n  return message.replace(/%[os]/gu, () => anyToString(args[i++]));\n}\n__name(format, \"format\");\nfunction anyToString(x) {\n  if (typeof x !== \"object\" || x === null) {\n    return String(x);\n  }\n  return Object.prototype.toString.call(x);\n}\n__name(anyToString, \"anyToString\");\nvar currentErrorHandler;\nfunction reportError(maybeError) {\n  try {\n    const error = maybeError instanceof Error ? maybeError : new Error(anyToString(maybeError));\n    if (currentErrorHandler) {\n      currentErrorHandler(error);\n      return;\n    }\n    if (typeof dispatchEvent === \"function\" && typeof ErrorEvent === \"function\") {\n      dispatchEvent(new ErrorEvent(\"error\", { error, message: error.message }));\n    } else if (typeof define_process_default !== \"undefined\" && typeof define_process_default.emit === \"function\") {\n      define_process_default.emit(\"uncaughtException\", error);\n      return;\n    }\n    console.error(error);\n  } catch (_a) {\n  }\n}\n__name(reportError, \"reportError\");\nvar Global = typeof window !== \"undefined\" ? window : typeof self !== \"undefined\" ? self : typeof global !== \"undefined\" ? global : typeof globalThis !== \"undefined\" ? globalThis : void 0;\nvar currentWarnHandler;\nvar Warning = class {\n  constructor(code, message) {\n    this.code = code;\n    this.message = message;\n  }\n  /**\n   * Report this warning.\n   * @param args The arguments of the warning.\n   */\n  warn(...args) {\n    var _a;\n    try {\n      if (currentWarnHandler) {\n        currentWarnHandler({ ...this, args });\n        return;\n      }\n      const stack = ((_a = new Error().stack) !== null && _a !== void 0 ? _a : \"\").replace(/^(?:.+?\\n){2}/gu, \"\\n\");\n      console.warn(this.message, ...args, stack);\n    } catch (_b) {\n    }\n  }\n};\n__name(Warning, \"Warning\");\nvar InitEventWasCalledWhileDispatching = new Warning(\"W01\", \"Unable to initialize event under dispatching.\");\nvar FalsyWasAssignedToCancelBubble = new Warning(\"W02\", \"Assigning any falsy value to 'cancelBubble' property has no effect.\");\nvar TruthyWasAssignedToReturnValue = new Warning(\"W03\", \"Assigning any truthy value to 'returnValue' property has no effect.\");\nvar NonCancelableEventWasCanceled = new Warning(\"W04\", \"Unable to preventDefault on non-cancelable events.\");\nvar CanceledInPassiveListener = new Warning(\"W05\", \"Unable to preventDefault inside passive event listener invocation.\");\nvar EventListenerWasDuplicated = new Warning(\"W06\", \"An event listener wasn't added because it has been added already: %o, %o\");\nvar OptionWasIgnored = new Warning(\"W07\", \"The %o option value was abandoned because the event listener wasn't added as duplicated.\");\nvar InvalidEventListener = new Warning(\"W08\", \"The 'callback' argument must be a function or an object that has 'handleEvent' method: %o\");\nvar InvalidAttributeHandler = new Warning(\"W09\", \"Event attribute handler must be a function: %o\");\nvar Event = class {\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-none\n   */\n  static get NONE() {\n    return NONE;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-capturing_phase\n   */\n  static get CAPTURING_PHASE() {\n    return CAPTURING_PHASE;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-at_target\n   */\n  static get AT_TARGET() {\n    return AT_TARGET;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-bubbling_phase\n   */\n  static get BUBBLING_PHASE() {\n    return BUBBLING_PHASE;\n  }\n  /**\n   * Initialize this event instance.\n   * @param type The type of this event.\n   * @param eventInitDict Options to initialize.\n   * @see https://dom.spec.whatwg.org/#dom-event-event\n   */\n  constructor(type, eventInitDict) {\n    Object.defineProperty(this, \"isTrusted\", {\n      value: false,\n      enumerable: true\n    });\n    const opts = eventInitDict !== null && eventInitDict !== void 0 ? eventInitDict : {};\n    internalDataMap.set(this, {\n      type: String(type),\n      bubbles: Boolean(opts.bubbles),\n      cancelable: Boolean(opts.cancelable),\n      composed: Boolean(opts.composed),\n      target: null,\n      currentTarget: null,\n      stopPropagationFlag: false,\n      stopImmediatePropagationFlag: false,\n      canceledFlag: false,\n      inPassiveListenerFlag: false,\n      dispatchFlag: false,\n      timeStamp: Date.now()\n    });\n  }\n  /**\n   * The type of this event.\n   * @see https://dom.spec.whatwg.org/#dom-event-type\n   */\n  get type() {\n    return $(this).type;\n  }\n  /**\n   * The event target of the current dispatching.\n   * @see https://dom.spec.whatwg.org/#dom-event-target\n   */\n  get target() {\n    return $(this).target;\n  }\n  /**\n   * The event target of the current dispatching.\n   * @deprecated Use the `target` property instead.\n   * @see https://dom.spec.whatwg.org/#dom-event-srcelement\n   */\n  get srcElement() {\n    return $(this).target;\n  }\n  /**\n   * The event target of the current dispatching.\n   * @see https://dom.spec.whatwg.org/#dom-event-currenttarget\n   */\n  get currentTarget() {\n    return $(this).currentTarget;\n  }\n  /**\n   * The event target of the current dispatching.\n   * This doesn't support node tree.\n   * @see https://dom.spec.whatwg.org/#dom-event-composedpath\n   */\n  composedPath() {\n    const currentTarget = $(this).currentTarget;\n    if (currentTarget) {\n      return [currentTarget];\n    }\n    return [];\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-none\n   */\n  get NONE() {\n    return NONE;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-capturing_phase\n   */\n  get CAPTURING_PHASE() {\n    return CAPTURING_PHASE;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-at_target\n   */\n  get AT_TARGET() {\n    return AT_TARGET;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-bubbling_phase\n   */\n  get BUBBLING_PHASE() {\n    return BUBBLING_PHASE;\n  }\n  /**\n   * The current event phase.\n   * @see https://dom.spec.whatwg.org/#dom-event-eventphase\n   */\n  get eventPhase() {\n    return $(this).dispatchFlag ? 2 : 0;\n  }\n  /**\n   * Stop event bubbling.\n   * Because this shim doesn't support node tree, this merely changes the `cancelBubble` property value.\n   * @see https://dom.spec.whatwg.org/#dom-event-stoppropagation\n   */\n  stopPropagation() {\n    $(this).stopPropagationFlag = true;\n  }\n  /**\n   * `true` if event bubbling was stopped.\n   * @deprecated\n   * @see https://dom.spec.whatwg.org/#dom-event-cancelbubble\n   */\n  get cancelBubble() {\n    return $(this).stopPropagationFlag;\n  }\n  /**\n   * Stop event bubbling if `true` is set.\n   * @deprecated Use the `stopPropagation()` method instead.\n   * @see https://dom.spec.whatwg.org/#dom-event-cancelbubble\n   */\n  set cancelBubble(value) {\n    if (value) {\n      $(this).stopPropagationFlag = true;\n    } else {\n      FalsyWasAssignedToCancelBubble.warn();\n    }\n  }\n  /**\n   * Stop event bubbling and subsequent event listener callings.\n   * @see https://dom.spec.whatwg.org/#dom-event-stopimmediatepropagation\n   */\n  stopImmediatePropagation() {\n    const data = $(this);\n    data.stopPropagationFlag = data.stopImmediatePropagationFlag = true;\n  }\n  /**\n   * `true` if this event will bubble.\n   * @see https://dom.spec.whatwg.org/#dom-event-bubbles\n   */\n  get bubbles() {\n    return $(this).bubbles;\n  }\n  /**\n   * `true` if this event can be canceled by the `preventDefault()` method.\n   * @see https://dom.spec.whatwg.org/#dom-event-cancelable\n   */\n  get cancelable() {\n    return $(this).cancelable;\n  }\n  /**\n   * `true` if the default behavior will act.\n   * @deprecated Use the `defaultPrevented` proeprty instead.\n   * @see https://dom.spec.whatwg.org/#dom-event-returnvalue\n   */\n  get returnValue() {\n    return !$(this).canceledFlag;\n  }\n  /**\n   * Cancel the default behavior if `false` is set.\n   * @deprecated Use the `preventDefault()` method instead.\n   * @see https://dom.spec.whatwg.org/#dom-event-returnvalue\n   */\n  set returnValue(value) {\n    if (!value) {\n      setCancelFlag($(this));\n    } else {\n      TruthyWasAssignedToReturnValue.warn();\n    }\n  }\n  /**\n   * Cancel the default behavior.\n   * @see https://dom.spec.whatwg.org/#dom-event-preventdefault\n   */\n  preventDefault() {\n    setCancelFlag($(this));\n  }\n  /**\n   * `true` if the default behavior was canceled.\n   * @see https://dom.spec.whatwg.org/#dom-event-defaultprevented\n   */\n  get defaultPrevented() {\n    return $(this).canceledFlag;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-composed\n   */\n  get composed() {\n    return $(this).composed;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-istrusted\n   */\n  //istanbul ignore next\n  get isTrusted() {\n    return false;\n  }\n  /**\n   * @see https://dom.spec.whatwg.org/#dom-event-timestamp\n   */\n  get timeStamp() {\n    return $(this).timeStamp;\n  }\n  /**\n   * @deprecated Don't use this method. The constructor did initialization.\n   */\n  initEvent(type, bubbles = false, cancelable = false) {\n    const data = $(this);\n    if (data.dispatchFlag) {\n      InitEventWasCalledWhileDispatching.warn();\n      return;\n    }\n    internalDataMap.set(this, {\n      ...data,\n      type: String(type),\n      bubbles: Boolean(bubbles),\n      cancelable: Boolean(cancelable),\n      target: null,\n      currentTarget: null,\n      stopPropagationFlag: false,\n      stopImmediatePropagationFlag: false,\n      canceledFlag: false\n    });\n  }\n};\n__name(Event, \"Event\");\nvar NONE = 0;\nvar CAPTURING_PHASE = 1;\nvar AT_TARGET = 2;\nvar BUBBLING_PHASE = 3;\nvar internalDataMap = /* @__PURE__ */ new WeakMap();\nfunction $(event, name = \"this\") {\n  const retv = internalDataMap.get(event);\n  assertType(retv != null, \"'%s' must be an object that Event constructor created, but got another one: %o\", name, event);\n  return retv;\n}\n__name($, \"$\");\nfunction setCancelFlag(data) {\n  if (data.inPassiveListenerFlag) {\n    CanceledInPassiveListener.warn();\n    return;\n  }\n  if (!data.cancelable) {\n    NonCancelableEventWasCanceled.warn();\n    return;\n  }\n  data.canceledFlag = true;\n}\n__name(setCancelFlag, \"setCancelFlag\");\nObject.defineProperty(Event, \"NONE\", { enumerable: true });\nObject.defineProperty(Event, \"CAPTURING_PHASE\", { enumerable: true });\nObject.defineProperty(Event, \"AT_TARGET\", { enumerable: true });\nObject.defineProperty(Event, \"BUBBLING_PHASE\", { enumerable: true });\nvar keys = Object.getOwnPropertyNames(Event.prototype);\nfor (let i = 0; i < keys.length; ++i) {\n  if (keys[i] === \"constructor\") {\n    continue;\n  }\n  Object.defineProperty(Event.prototype, keys[i], { enumerable: true });\n}\nif (typeof Global !== \"undefined\" && typeof Global.Event !== \"undefined\") {\n  Object.setPrototypeOf(Event.prototype, Global.Event.prototype);\n}\nfunction createInvalidStateError(message) {\n  if (Global.DOMException) {\n    return new Global.DOMException(message, \"InvalidStateError\");\n  }\n  if (DOMException == null) {\n    DOMException = /* @__PURE__ */ __name(class DOMException2 extends Error {\n      constructor(msg) {\n        super(msg);\n        if (Error.captureStackTrace) {\n          Error.captureStackTrace(this, DOMException2);\n        }\n      }\n      // eslint-disable-next-line class-methods-use-this\n      get code() {\n        return 11;\n      }\n      // eslint-disable-next-line class-methods-use-this\n      get name() {\n        return \"InvalidStateError\";\n      }\n    }, \"DOMException\");\n    Object.defineProperties(DOMException.prototype, {\n      code: { enumerable: true },\n      name: { enumerable: true }\n    });\n    defineErrorCodeProperties(DOMException);\n    defineErrorCodeProperties(DOMException.prototype);\n  }\n  return new DOMException(message);\n}\n__name(createInvalidStateError, \"createInvalidStateError\");\nvar DOMException;\nvar ErrorCodeMap = {\n  INDEX_SIZE_ERR: 1,\n  DOMSTRING_SIZE_ERR: 2,\n  HIERARCHY_REQUEST_ERR: 3,\n  WRONG_DOCUMENT_ERR: 4,\n  INVALID_CHARACTER_ERR: 5,\n  NO_DATA_ALLOWED_ERR: 6,\n  NO_MODIFICATION_ALLOWED_ERR: 7,\n  NOT_FOUND_ERR: 8,\n  NOT_SUPPORTED_ERR: 9,\n  INUSE_ATTRIBUTE_ERR: 10,\n  INVALID_STATE_ERR: 11,\n  SYNTAX_ERR: 12,\n  INVALID_MODIFICATION_ERR: 13,\n  NAMESPACE_ERR: 14,\n  INVALID_ACCESS_ERR: 15,\n  VALIDATION_ERR: 16,\n  TYPE_MISMATCH_ERR: 17,\n  SECURITY_ERR: 18,\n  NETWORK_ERR: 19,\n  ABORT_ERR: 20,\n  URL_MISMATCH_ERR: 21,\n  QUOTA_EXCEEDED_ERR: 22,\n  TIMEOUT_ERR: 23,\n  INVALID_NODE_TYPE_ERR: 24,\n  DATA_CLONE_ERR: 25\n};\nfunction defineErrorCodeProperties(obj) {\n  const keys2 = Object.keys(ErrorCodeMap);\n  for (let i = 0; i < keys2.length; ++i) {\n    const key = keys2[i];\n    const value = ErrorCodeMap[key];\n    Object.defineProperty(obj, key, {\n      get() {\n        return value;\n      },\n      configurable: true,\n      enumerable: true\n    });\n  }\n}\n__name(defineErrorCodeProperties, \"defineErrorCodeProperties\");\nvar EventWrapper = class extends Event {\n  /**\n   * Wrap a given event object to control states.\n   * @param event The event-like object to wrap.\n   */\n  static wrap(event) {\n    return new (getWrapperClassOf(event))(event);\n  }\n  constructor(event) {\n    super(event.type, {\n      bubbles: event.bubbles,\n      cancelable: event.cancelable,\n      composed: event.composed\n    });\n    if (event.cancelBubble) {\n      super.stopPropagation();\n    }\n    if (event.defaultPrevented) {\n      super.preventDefault();\n    }\n    internalDataMap$1.set(this, { original: event });\n    const keys2 = Object.keys(event);\n    for (let i = 0; i < keys2.length; ++i) {\n      const key = keys2[i];\n      if (!(key in this)) {\n        Object.defineProperty(this, key, defineRedirectDescriptor(event, key));\n      }\n    }\n  }\n  stopPropagation() {\n    super.stopPropagation();\n    const { original } = $$1(this);\n    if (\"stopPropagation\" in original) {\n      original.stopPropagation();\n    }\n  }\n  get cancelBubble() {\n    return super.cancelBubble;\n  }\n  set cancelBubble(value) {\n    super.cancelBubble = value;\n    const { original } = $$1(this);\n    if (\"cancelBubble\" in original) {\n      original.cancelBubble = value;\n    }\n  }\n  stopImmediatePropagation() {\n    super.stopImmediatePropagation();\n    const { original } = $$1(this);\n    if (\"stopImmediatePropagation\" in original) {\n      original.stopImmediatePropagation();\n    }\n  }\n  get returnValue() {\n    return super.returnValue;\n  }\n  set returnValue(value) {\n    super.returnValue = value;\n    const { original } = $$1(this);\n    if (\"returnValue\" in original) {\n      original.returnValue = value;\n    }\n  }\n  preventDefault() {\n    super.preventDefault();\n    const { original } = $$1(this);\n    if (\"preventDefault\" in original) {\n      original.preventDefault();\n    }\n  }\n  get timeStamp() {\n    const { original } = $$1(this);\n    if (\"timeStamp\" in original) {\n      return original.timeStamp;\n    }\n    return super.timeStamp;\n  }\n};\n__name(EventWrapper, \"EventWrapper\");\nvar internalDataMap$1 = /* @__PURE__ */ new WeakMap();\nfunction $$1(event) {\n  const retv = internalDataMap$1.get(event);\n  assertType(retv != null, \"'this' is expected an Event object, but got\", event);\n  return retv;\n}\n__name($$1, \"$$1\");\nvar wrapperClassCache = /* @__PURE__ */ new WeakMap();\nwrapperClassCache.set(Object.prototype, EventWrapper);\nif (typeof Global !== \"undefined\" && typeof Global.Event !== \"undefined\") {\n  wrapperClassCache.set(Global.Event.prototype, EventWrapper);\n}\nfunction getWrapperClassOf(originalEvent) {\n  const prototype = Object.getPrototypeOf(originalEvent);\n  if (prototype == null) {\n    return EventWrapper;\n  }\n  let wrapper = wrapperClassCache.get(prototype);\n  if (wrapper == null) {\n    wrapper = defineWrapper(getWrapperClassOf(prototype), prototype);\n    wrapperClassCache.set(prototype, wrapper);\n  }\n  return wrapper;\n}\n__name(getWrapperClassOf, \"getWrapperClassOf\");\nfunction defineWrapper(BaseEventWrapper, originalPrototype) {\n  class CustomEventWrapper extends BaseEventWrapper {\n  }\n  __name(CustomEventWrapper, \"CustomEventWrapper\");\n  const keys2 = Object.keys(originalPrototype);\n  for (let i = 0; i < keys2.length; ++i) {\n    Object.defineProperty(CustomEventWrapper.prototype, keys2[i], defineRedirectDescriptor(originalPrototype, keys2[i]));\n  }\n  return CustomEventWrapper;\n}\n__name(defineWrapper, \"defineWrapper\");\nfunction defineRedirectDescriptor(obj, key) {\n  const d = Object.getOwnPropertyDescriptor(obj, key);\n  return {\n    get() {\n      const original = $$1(this).original;\n      const value = original[key];\n      if (typeof value === \"function\") {\n        return value.bind(original);\n      }\n      return value;\n    },\n    set(value) {\n      const original = $$1(this).original;\n      original[key] = value;\n    },\n    configurable: d.configurable,\n    enumerable: d.enumerable\n  };\n}\n__name(defineRedirectDescriptor, \"defineRedirectDescriptor\");\nfunction createListener(callback, capture, passive, once, signal, signalListener) {\n  return {\n    callback,\n    flags: (capture ? 1 : 0) | (passive ? 2 : 0) | (once ? 4 : 0),\n    signal,\n    signalListener\n  };\n}\n__name(createListener, \"createListener\");\nfunction setRemoved(listener) {\n  listener.flags |= 8;\n}\n__name(setRemoved, \"setRemoved\");\nfunction isCapture(listener) {\n  return (listener.flags & 1) === 1;\n}\n__name(isCapture, \"isCapture\");\nfunction isPassive(listener) {\n  return (listener.flags & 2) === 2;\n}\n__name(isPassive, \"isPassive\");\nfunction isOnce(listener) {\n  return (listener.flags & 4) === 4;\n}\n__name(isOnce, \"isOnce\");\nfunction isRemoved(listener) {\n  return (listener.flags & 8) === 8;\n}\n__name(isRemoved, \"isRemoved\");\nfunction invokeCallback({ callback }, target, event) {\n  try {\n    if (typeof callback === \"function\") {\n      callback.call(target, event);\n    } else if (typeof callback.handleEvent === \"function\") {\n      callback.handleEvent(event);\n    }\n  } catch (thrownError) {\n    reportError(thrownError);\n  }\n}\n__name(invokeCallback, \"invokeCallback\");\nfunction findIndexOfListener({ listeners }, callback, capture) {\n  for (let i = 0; i < listeners.length; ++i) {\n    if (listeners[i].callback === callback && isCapture(listeners[i]) === capture) {\n      return i;\n    }\n  }\n  return -1;\n}\n__name(findIndexOfListener, \"findIndexOfListener\");\nfunction addListener(list, callback, capture, passive, once, signal) {\n  let signalListener;\n  if (signal) {\n    signalListener = removeListener.bind(null, list, callback, capture);\n    signal.addEventListener(\"abort\", signalListener);\n  }\n  const listener = createListener(callback, capture, passive, once, signal, signalListener);\n  if (list.cow) {\n    list.cow = false;\n    list.listeners = [...list.listeners, listener];\n  } else {\n    list.listeners.push(listener);\n  }\n  return listener;\n}\n__name(addListener, \"addListener\");\nfunction removeListener(list, callback, capture) {\n  const index = findIndexOfListener(list, callback, capture);\n  if (index !== -1) {\n    return removeListenerAt(list, index);\n  }\n  return false;\n}\n__name(removeListener, \"removeListener\");\nfunction removeListenerAt(list, index, disableCow = false) {\n  const listener = list.listeners[index];\n  setRemoved(listener);\n  if (listener.signal) {\n    listener.signal.removeEventListener(\"abort\", listener.signalListener);\n  }\n  if (list.cow && !disableCow) {\n    list.cow = false;\n    list.listeners = list.listeners.filter((_, i) => i !== index);\n    return false;\n  }\n  list.listeners.splice(index, 1);\n  return true;\n}\n__name(removeListenerAt, \"removeListenerAt\");\nfunction createListenerListMap() {\n  return /* @__PURE__ */ Object.create(null);\n}\n__name(createListenerListMap, \"createListenerListMap\");\nfunction ensureListenerList(listenerMap, type) {\n  var _a;\n  return (_a = listenerMap[type]) !== null && _a !== void 0 ? _a : listenerMap[type] = {\n    attrCallback: void 0,\n    attrListener: void 0,\n    cow: false,\n    listeners: []\n  };\n}\n__name(ensureListenerList, \"ensureListenerList\");\nvar EventTarget = class {\n  /**\n   * Initialize this instance.\n   */\n  constructor() {\n    internalDataMap$2.set(this, createListenerListMap());\n  }\n  // Implementation\n  addEventListener(type0, callback0, options0) {\n    const listenerMap = $$2(this);\n    const { callback, capture, once, passive, signal, type } = normalizeAddOptions(type0, callback0, options0);\n    if (callback == null || (signal === null || signal === void 0 ? void 0 : signal.aborted)) {\n      return;\n    }\n    const list = ensureListenerList(listenerMap, type);\n    const i = findIndexOfListener(list, callback, capture);\n    if (i !== -1) {\n      warnDuplicate(list.listeners[i], passive, once, signal);\n      return;\n    }\n    addListener(list, callback, capture, passive, once, signal);\n  }\n  // Implementation\n  removeEventListener(type0, callback0, options0) {\n    const listenerMap = $$2(this);\n    const { callback, capture, type } = normalizeOptions(type0, callback0, options0);\n    const list = listenerMap[type];\n    if (callback != null && list) {\n      removeListener(list, callback, capture);\n    }\n  }\n  // Implementation\n  dispatchEvent(e) {\n    const list = $$2(this)[String(e.type)];\n    if (list == null) {\n      return true;\n    }\n    const event = e instanceof Event ? e : EventWrapper.wrap(e);\n    const eventData = $(event, \"event\");\n    if (eventData.dispatchFlag) {\n      throw createInvalidStateError(\"This event has been in dispatching.\");\n    }\n    eventData.dispatchFlag = true;\n    eventData.target = eventData.currentTarget = this;\n    if (!eventData.stopPropagationFlag) {\n      const { cow, listeners } = list;\n      list.cow = true;\n      for (let i = 0; i < listeners.length; ++i) {\n        const listener = listeners[i];\n        if (isRemoved(listener)) {\n          continue;\n        }\n        if (isOnce(listener) && removeListenerAt(list, i, !cow)) {\n          i -= 1;\n        }\n        eventData.inPassiveListenerFlag = isPassive(listener);\n        invokeCallback(listener, this, event);\n        eventData.inPassiveListenerFlag = false;\n        if (eventData.stopImmediatePropagationFlag) {\n          break;\n        }\n      }\n      if (!cow) {\n        list.cow = false;\n      }\n    }\n    eventData.target = null;\n    eventData.currentTarget = null;\n    eventData.stopImmediatePropagationFlag = false;\n    eventData.stopPropagationFlag = false;\n    eventData.dispatchFlag = false;\n    return !eventData.canceledFlag;\n  }\n};\n__name(EventTarget, \"EventTarget\");\nvar internalDataMap$2 = /* @__PURE__ */ new WeakMap();\nfunction $$2(target, name = \"this\") {\n  const retv = internalDataMap$2.get(target);\n  assertType(retv != null, \"'%s' must be an object that EventTarget constructor created, but got another one: %o\", name, target);\n  return retv;\n}\n__name($$2, \"$$2\");\nfunction normalizeAddOptions(type, callback, options) {\n  var _a;\n  assertCallback(callback);\n  if (typeof options === \"object\" && options !== null) {\n    return {\n      type: String(type),\n      callback: callback !== null && callback !== void 0 ? callback : void 0,\n      capture: Boolean(options.capture),\n      passive: Boolean(options.passive),\n      once: Boolean(options.once),\n      signal: (_a = options.signal) !== null && _a !== void 0 ? _a : void 0\n    };\n  }\n  return {\n    type: String(type),\n    callback: callback !== null && callback !== void 0 ? callback : void 0,\n    capture: Boolean(options),\n    passive: false,\n    once: false,\n    signal: void 0\n  };\n}\n__name(normalizeAddOptions, \"normalizeAddOptions\");\nfunction normalizeOptions(type, callback, options) {\n  assertCallback(callback);\n  if (typeof options === \"object\" && options !== null) {\n    return {\n      type: String(type),\n      callback: callback !== null && callback !== void 0 ? callback : void 0,\n      capture: Boolean(options.capture)\n    };\n  }\n  return {\n    type: String(type),\n    callback: callback !== null && callback !== void 0 ? callback : void 0,\n    capture: Boolean(options)\n  };\n}\n__name(normalizeOptions, \"normalizeOptions\");\nfunction assertCallback(callback) {\n  if (typeof callback === \"function\" || typeof callback === \"object\" && callback !== null && typeof callback.handleEvent === \"function\") {\n    return;\n  }\n  if (callback == null || typeof callback === \"object\") {\n    InvalidEventListener.warn(callback);\n    return;\n  }\n  throw new TypeError(format(InvalidEventListener.message, [callback]));\n}\n__name(assertCallback, \"assertCallback\");\nfunction warnDuplicate(listener, passive, once, signal) {\n  EventListenerWasDuplicated.warn(isCapture(listener) ? \"capture\" : \"bubble\", listener.callback);\n  if (isPassive(listener) !== passive) {\n    OptionWasIgnored.warn(\"passive\");\n  }\n  if (isOnce(listener) !== once) {\n    OptionWasIgnored.warn(\"once\");\n  }\n  if (listener.signal !== signal) {\n    OptionWasIgnored.warn(\"signal\");\n  }\n}\n__name(warnDuplicate, \"warnDuplicate\");\nvar keys$1 = Object.getOwnPropertyNames(EventTarget.prototype);\nfor (let i = 0; i < keys$1.length; ++i) {\n  if (keys$1[i] === \"constructor\") {\n    continue;\n  }\n  Object.defineProperty(EventTarget.prototype, keys$1[i], { enumerable: true });\n}\nif (typeof Global !== \"undefined\" && typeof Global.EventTarget !== \"undefined\") {\n  Object.setPrototypeOf(EventTarget.prototype, Global.EventTarget.prototype);\n}\n\n// src/primitives/events.js\nvar FetchEvent = class extends Event {\n  constructor(request) {\n    super(\"fetch\");\n    this.request = request;\n    this.response = null;\n    this.awaiting = /* @__PURE__ */ new Set();\n  }\n  respondWith(response) {\n    this.response = response;\n  }\n  waitUntil(promise) {\n    this.awaiting.add(promise);\n    promise.finally(() => this.awaiting.delete(promise));\n  }\n};\n__name(FetchEvent, \"FetchEvent\");\nvar PromiseRejectionEvent = class extends Event {\n  constructor(type, init) {\n    super(type, { cancelable: true });\n    this.promise = init.promise;\n    this.reason = init.reason;\n  }\n};\n__name(PromiseRejectionEvent, \"PromiseRejectionEvent\");\n// Annotate the CommonJS export names for ESM import in node:\n0 && (module.exports = {\n  Event,\n  EventTarget,\n  FetchEvent,\n  PromiseRejectionEvent\n});\n"