import _m0 from "protobufjs/minimal";
import { Any } from "../../../google/protobuf/any";
export declare const protobufPackage = "cosmwasm.wasm.v1";
/** AccessType permission types */
export declare enum AccessType {
    /** ACCESS_TYPE_UNSPECIFIED - AccessTypeUnspecified placeholder for empty value */
    ACCESS_TYPE_UNSPECIFIED = 0,
    /** ACCESS_TYPE_NOBODY - AccessTypeNobody forbidden */
    ACCESS_TYPE_NOBODY = 1,
    /** ACCESS_TYPE_ONLY_ADDRESS - AccessTypeOnlyAddress restricted to an address */
    ACCESS_TYPE_ONLY_ADDRESS = 2,
    /** ACCESS_TYPE_EVERYBODY - AccessTypeEverybody unrestricted */
    ACCESS_TYPE_EVERYBODY = 3,
    UNRECOGNIZED = -1
}
export declare function accessTypeFromJSON(object: any): AccessType;
export declare function accessTypeToJSON(object: AccessType): string;
/** ContractCodeHistoryOperationType actions that caused a code change */
export declare enum ContractCodeHistoryOperationType {
    /** CONTRACT_CODE_HISTORY_OPERATION_TYPE_UNSPECIFIED - ContractCodeHistoryOperationTypeUnspecified placeholder for empty value */
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_UNSPECIFIED = 0,
    /** CONTRACT_CODE_HISTORY_OPERATION_TYPE_INIT - ContractCodeHistoryOperationTypeInit on chain contract instantiation */
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_INIT = 1,
    /** CONTRACT_CODE_HISTORY_OPERATION_TYPE_MIGRATE - ContractCodeHistoryOperationTypeMigrate code migration */
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_MIGRATE = 2,
    /** CONTRACT_CODE_HISTORY_OPERATION_TYPE_GENESIS - ContractCodeHistoryOperationTypeGenesis based on genesis data */
    CONTRACT_CODE_HISTORY_OPERATION_TYPE_GENESIS = 3,
    UNRECOGNIZED = -1
}
export declare function contractCodeHistoryOperationTypeFromJSON(object: any): ContractCodeHistoryOperationType;
export declare function contractCodeHistoryOperationTypeToJSON(object: ContractCodeHistoryOperationType): string;
/** AccessTypeParam */
export interface AccessTypeParam {
    value: AccessType;
}
/** AccessConfig access control type. */
export interface AccessConfig {
    permission: AccessType;
    address: string;
}
/** Params defines the set of wasm parameters. */
export interface Params {
    codeUploadAccess: AccessConfig | undefined;
    instantiateDefaultPermission: AccessType;
    maxWasmCodeSize: string;
}
/** CodeInfo is data for the uploaded contract WASM code */
export interface CodeInfo {
    /** CodeHash is the unique identifier created by wasmvm */
    codeHash: Uint8Array;
    /** Creator address who initially stored the code */
    creator: string;
    /** InstantiateConfig access control to apply on contract creation, optional */
    instantiateConfig: AccessConfig | undefined;
}
/** ContractInfo stores a WASM contract instance */
export interface ContractInfo {
    /** CodeID is the reference to the stored Wasm code */
    codeId: string;
    /** Creator address who initially instantiated the contract */
    creator: string;
    /** Admin is an optional address that can execute migrations */
    admin: string;
    /** Label is optional metadata to be stored with a contract instance. */
    label: string;
    /**
     * Created Tx position when the contract was instantiated.
     * This data should kept internal and not be exposed via query results. Just
     * use for sorting
     */
    created: AbsoluteTxPosition | undefined;
    ibcPortId: string;
    /**
     * Extension is an extension point to store custom metadata within the
     * persistence model.
     */
    extension: Any | undefined;
}
/** ContractCodeHistoryEntry metadata to a contract. */
export interface ContractCodeHistoryEntry {
    operation: ContractCodeHistoryOperationType;
    /** CodeID is the reference to the stored WASM code */
    codeId: string;
    /** Updated Tx position when the operation was executed. */
    updated: AbsoluteTxPosition | undefined;
    msg: Uint8Array;
}
/**
 * AbsoluteTxPosition is a unique transaction position that allows for global
 * ordering of transactions.
 */
export interface AbsoluteTxPosition {
    /** BlockHeight is the block the contract was created at */
    blockHeight: string;
    /**
     * TxIndex is a monotonic counter within the block (actual transaction index,
     * or gas consumed)
     */
    txIndex: string;
}
/** Model is a struct that holds a KV pair */
export interface Model {
    /** hex-encode key to read it better (this is often ascii) */
    key: Uint8Array;
    /** base64-encode raw value */
    value: Uint8Array;
}
export declare const AccessTypeParam: {
    encode(message: AccessTypeParam, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): AccessTypeParam;
    fromJSON(object: any): AccessTypeParam;
    toJSON(message: AccessTypeParam): unknown;
    fromPartial<I extends {
        value?: AccessType | undefined;
    } & {
        value?: AccessType | undefined;
    } & Record<Exclude<keyof I, "value">, never>>(object: I): AccessTypeParam;
};
export declare const AccessConfig: {
    encode(message: AccessConfig, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): AccessConfig;
    fromJSON(object: any): AccessConfig;
    toJSON(message: AccessConfig): unknown;
    fromPartial<I extends {
        permission?: AccessType | undefined;
        address?: string | undefined;
    } & {
        permission?: AccessType | undefined;
        address?: string | undefined;
    } & Record<Exclude<keyof I, "address" | "permission">, never>>(object: I): AccessConfig;
};
export declare const Params: {
    encode(message: Params, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): Params;
    fromJSON(object: any): Params;
    toJSON(message: Params): unknown;
    fromPartial<I extends {
        codeUploadAccess?: {
            permission?: AccessType | undefined;
            address?: string | undefined;
        } | undefined;
        instantiateDefaultPermission?: AccessType | undefined;
        maxWasmCodeSize?: string | undefined;
    } & {
        codeUploadAccess?: ({
            permission?: AccessType | undefined;
            address?: string | undefined;
        } & {
            permission?: AccessType | undefined;
            address?: string | undefined;
        } & Record<Exclude<keyof I["codeUploadAccess"], "address" | "permission">, never>) | undefined;
        instantiateDefaultPermission?: AccessType | undefined;
        maxWasmCodeSize?: string | undefined;
    } & Record<Exclude<keyof I, "codeUploadAccess" | "instantiateDefaultPermission" | "maxWasmCodeSize">, never>>(object: I): Params;
};
export declare const CodeInfo: {
    encode(message: CodeInfo, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): CodeInfo;
    fromJSON(object: any): CodeInfo;
    toJSON(message: CodeInfo): unknown;
    fromPartial<I extends {
        codeHash?: Uint8Array | undefined;
        creator?: string | undefined;
        instantiateConfig?: {
            permission?: AccessType | undefined;
            address?: string | undefined;
        } | undefined;
    } & {
        codeHash?: Uint8Array | undefined;
        creator?: string | undefined;
        instantiateConfig?: ({
            permission?: AccessType | undefined;
            address?: string | undefined;
        } & {
            permission?: AccessType | undefined;
            address?: string | undefined;
        } & Record<Exclude<keyof I["instantiateConfig"], "address" | "permission">, never>) | undefined;
    } & Record<Exclude<keyof I, "codeHash" | "creator" | "instantiateConfig">, never>>(object: I): CodeInfo;
};
export declare const ContractInfo: {
    encode(message: ContractInfo, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): ContractInfo;
    fromJSON(object: any): ContractInfo;
    toJSON(message: ContractInfo): unknown;
    fromPartial<I extends {
        codeId?: string | undefined;
        creator?: string | undefined;
        admin?: string | undefined;
        label?: string | undefined;
        created?: {
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } | undefined;
        ibcPortId?: string | undefined;
        extension?: {
            typeUrl?: string | undefined;
            value?: Uint8Array | undefined;
        } | undefined;
    } & {
        codeId?: string | undefined;
        creator?: string | undefined;
        admin?: string | undefined;
        label?: string | undefined;
        created?: ({
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } & {
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } & Record<Exclude<keyof I["created"], "blockHeight" | "txIndex">, never>) | undefined;
        ibcPortId?: string | undefined;
        extension?: ({
            typeUrl?: string | undefined;
            value?: Uint8Array | undefined;
        } & {
            typeUrl?: string | undefined;
            value?: Uint8Array | undefined;
        } & Record<Exclude<keyof I["extension"], "typeUrl" | "value">, never>) | undefined;
    } & Record<Exclude<keyof I, "label" | "creator" | "codeId" | "admin" | "created" | "ibcPortId" | "extension">, never>>(object: I): ContractInfo;
};
export declare const ContractCodeHistoryEntry: {
    encode(message: ContractCodeHistoryEntry, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): ContractCodeHistoryEntry;
    fromJSON(object: any): ContractCodeHistoryEntry;
    toJSON(message: ContractCodeHistoryEntry): unknown;
    fromPartial<I extends {
        operation?: ContractCodeHistoryOperationType | undefined;
        codeId?: string | undefined;
        updated?: {
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } | undefined;
        msg?: Uint8Array | undefined;
    } & {
        operation?: ContractCodeHistoryOperationType | undefined;
        codeId?: string | undefined;
        updated?: ({
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } & {
            blockHeight?: string | undefined;
            txIndex?: string | undefined;
        } & Record<Exclude<keyof I["updated"], "blockHeight" | "txIndex">, never>) | undefined;
        msg?: Uint8Array | undefined;
    } & Record<Exclude<keyof I, "msg" | "codeId" | "operation" | "updated">, never>>(object: I): ContractCodeHistoryEntry;
};
export declare const AbsoluteTxPosition: {
    encode(message: AbsoluteTxPosition, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): AbsoluteTxPosition;
    fromJSON(object: any): AbsoluteTxPosition;
    toJSON(message: AbsoluteTxPosition): unknown;
    fromPartial<I extends {
        blockHeight?: string | undefined;
        txIndex?: string | undefined;
    } & {
        blockHeight?: string | undefined;
        txIndex?: string | undefined;
    } & Record<Exclude<keyof I, "blockHeight" | "txIndex">, never>>(object: I): AbsoluteTxPosition;
};
export declare const Model: {
    encode(message: Model, writer?: _m0.Writer): _m0.Writer;
    decode(input: _m0.Reader | Uint8Array, length?: number | undefined): Model;
    fromJSON(object: any): Model;
    toJSON(message: Model): unknown;
    fromPartial<I extends {
        key?: Uint8Array | undefined;
        value?: Uint8Array | undefined;
    } & {
        key?: Uint8Array | undefined;
        value?: Uint8Array | undefined;
    } & Record<Exclude<keyof I, "value" | "key">, never>>(object: I): Model;
};
declare type Builtin = Date | Function | Uint8Array | string | number | boolean | undefined;
export declare type DeepPartial<T> = T extends Builtin ? T : T extends Array<infer U> ? Array<DeepPartial<U>> : T extends ReadonlyArray<infer U> ? ReadonlyArray<DeepPartial<U>> : T extends {} ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : Partial<T>;
declare type KeysOfUnion<T> = T extends T ? keyof T : never;
export declare type Exact<P, I extends P> = P extends Builtin ? P : P & {
    [K in keyof P]: Exact<P[K], I[K]>;
} & Record<Exclude<keyof I, KeysOfUnion<P>>, never>;
export {};
