import { IntPretty, IntPrettyOptions } from "./int-pretty";
import { Dec } from "./decimal";
import { AppCurrency } from "@keplr-wallet/types";
import { DeepReadonly } from "utility-types";
import bigInteger from "big-integer";
export declare type CoinPrettyOptions = {
    separator: string;
    upperCase: boolean;
    lowerCase: boolean;
    hideDenom: boolean;
};
export declare class CoinPretty {
    protected _currency: AppCurrency;
    protected amount: Dec | {
        toDec(): Dec;
    } | bigInteger.BigNumber;
    protected intPretty: IntPretty;
    protected _options: CoinPrettyOptions;
    constructor(_currency: AppCurrency, amount: Dec | {
        toDec(): Dec;
    } | bigInteger.BigNumber);
    get options(): DeepReadonly<IntPrettyOptions & CoinPrettyOptions>;
    get denom(): string;
    get currency(): AppCurrency;
    setCurrency(currency: AppCurrency): CoinPretty;
    separator(str: string): CoinPretty;
    upperCase(bool: boolean): CoinPretty;
    lowerCase(bool: boolean): CoinPretty;
    hideDenom(bool: boolean): CoinPretty;
    moveDecimalPointLeft(delta: number): CoinPretty;
    moveDecimalPointRight(delta: number): CoinPretty;
    /**
     * @deprecated Use`moveDecimalPointLeft`
     */
    increasePrecision(delta: number): CoinPretty;
    /**
     * @deprecated Use`moveDecimalPointRight`
     */
    decreasePrecision(delta: number): CoinPretty;
    maxDecimals(max: number): CoinPretty;
    inequalitySymbol(bool: boolean): CoinPretty;
    inequalitySymbolSeparator(str: string): CoinPretty;
    trim(bool: boolean): CoinPretty;
    shrink(bool: boolean): CoinPretty;
    locale(locale: boolean): CoinPretty;
    /**
     * Ready indicates the actual value is ready to show the users.
     * Even if the ready option is false, it expects that the value can be shown to users (probably as 0).
     * The method that returns prettied value may return `undefined` or `null` if the value is not ready.
     * But, alternatively, it can return the 0 value that can be shown the users anyway, but indicates that the value is not ready.
     * @param bool
     */
    ready(bool: boolean): CoinPretty;
    get isReady(): boolean;
    add(target: Dec | {
        toDec(): Dec;
    } | CoinPretty): CoinPretty;
    sub(target: Dec | {
        toDec(): Dec;
    } | CoinPretty): CoinPretty;
    mul(target: Dec | {
        toDec(): Dec;
    }): CoinPretty;
    quo(target: Dec | {
        toDec(): Dec;
    }): CoinPretty;
    toDec(): Dec;
    toCoin(): {
        denom: string;
        amount: string;
    };
    toString(): string;
    clone(): CoinPretty;
}
