import { Coin } from "./coin";
import { Int } from "./int";
import { Dec } from "./decimal";
import { Currency } from "@keplr-wallet/types";
export declare class CoinUtils {
    static createCoinsFromPrimitives(coinPrimitives: {
        denom: string;
        amount: string;
    }[]): Coin[];
    static amountOf(coins: Coin[], denom: string): Int;
    static exclude(coins: Coin[], demons: string[]): Coin[];
    static concat(...coins: Coin[]): Coin[];
    static getCoinFromDecimals(currencies: Currency[], decAmountStr: string, denom: string): Coin;
    static parseDecAndDenomFromCoin(currencies: Currency[], coin: Coin): {
        amount: string;
        denom: string;
    };
    static shrinkDecimals(dec: Dec, minDecimals: number, maxDecimals: number, locale?: boolean): string;
    /**
     * Change the non-locale integer string to locale string.
     * Only support en-US format.
     * This method uses the BigInt if the environment supports the BigInt.
     * @param numberStr
     */
    static integerStringToUSLocaleString(numberStr: string): string;
    static coinToTrimmedString(coin: Coin, currency: Currency, separator?: string): string;
}
