"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const coin_utils_1 = require("./coin-utils");
const decimal_1 = require("./decimal");
describe("Test CoinUtils", () => {
    it("Test integerStringToUSLocaleString", () => {
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("123456789")).toBe("123,456,789");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("0")).toBe("0");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("123")).toBe("123");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("12")).toBe("12");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("1234")).toBe("1,234");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("-1234")).toBe("-1,234");
        expect(coin_utils_1.CoinUtils.integerStringToUSLocaleString("-123456789")).toBe("-123,456,789");
    });
    it("Test shrink", () => {
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234.56789), 3, 6)).toBe("1234.567");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234.56789), 3, 6, true)).toBe("1,234.567");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234), 3, 6)).toBe("1234.000");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(-1234.56789), 3, 6)).toBe("-1234.567");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(-1234.56789), 3, 6, true)).toBe("-1,234.567");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234.56789), 0, 0)).toBe("1234");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(-1234.56789), 0, 0)).toBe("-1234");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234.56789), 1, 1)).toBe("1234.5");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(-1234.56789), 1, 1)).toBe("-1234.5");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(1234), 1, 1)).toBe("1234.0");
        expect(coin_utils_1.CoinUtils.shrinkDecimals(new decimal_1.Dec(-1234), 1, 1)).toBe("-1234.0");
    });
});
//# sourceMappingURL=coin-utils.spec.js.map