"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DecUtils = void 0;
const decimal_1 = require("./decimal");
const int_1 = require("./int");
class DecUtils {
    static trim(dec) {
        let decStr = typeof dec === "string" ? dec : dec.toString();
        if (decStr.indexOf(".") < 0) {
            return decStr;
        }
        for (let i = decStr.length - 1; i >= 0; i--) {
            if (decStr[i] === "0") {
                decStr = decStr.slice(0, i);
            }
            else {
                break;
            }
        }
        if (decStr.length > 0) {
            if (decStr[decStr.length - 1] === ".") {
                decStr = decStr.slice(0, decStr.length - 1);
            }
        }
        return decStr;
    }
    static getTenExponentN(n) {
        if (n < -decimal_1.Dec.precision) {
            // Dec can only handle up to precision 18.
            // Anything less than 18 precision is 0, so there is a high probability of an error.
            throw new Error("Too little precision");
        }
        if (DecUtils.tenExponentNs[n.toString()]) {
            return DecUtils.tenExponentNs[n.toString()];
        }
        const dec = new decimal_1.Dec(10).pow(new int_1.Int(n));
        DecUtils.tenExponentNs[n.toString()] = dec;
        return dec;
    }
    static getTenExponentNInPrecisionRange(n) {
        if (n > decimal_1.Dec.precision) {
            throw new Error("Too much precision");
        }
        return DecUtils.getTenExponentN(n);
    }
    /**
     * @deprecated Use`getTenExponentNInPrecisionRange`
     */
    static getPrecisionDec(precision) {
        return DecUtils.getTenExponentNInPrecisionRange(precision);
    }
}
exports.DecUtils = DecUtils;
DecUtils.tenExponentNs = {};
//# sourceMappingURL=dec-utils.js.map