"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exponentDecStringToDecString = exports.isExponentDecString = exports.isValidDecimalString = exports.isValidIntegerString = void 0;
const regexIntString = /^-?\d+$/;
const regexDecString = /^-?\d+.?\d*$/;
const regexExponentDecString = /^(-?)([\d.]+)e([-+])([\d]+)$/;
function isValidIntegerString(str) {
    return regexIntString.test(str);
}
exports.isValidIntegerString = isValidIntegerString;
function isValidDecimalString(str) {
    return regexDecString.test(str);
}
exports.isValidDecimalString = isValidDecimalString;
function isExponentDecString(str) {
    return regexExponentDecString.test(str);
}
exports.isExponentDecString = isExponentDecString;
function makeZerosStr(len) {
    let r = "";
    for (let i = 0; i < len; i++) {
        r += "0";
    }
    return r;
}
function removeHeadZeros(str) {
    while (str.length > 0 && str[0] === "0") {
        str = str.slice(1);
    }
    if (str.length === 0 || str[0] === ".") {
        return "0" + str;
    }
    return str;
}
function exponentDecStringToDecString(str) {
    const split = str.split(regexExponentDecString);
    if (split.length !== 6) {
        return str;
    }
    const isNeg = split[1] === "-";
    let numStr = split[2];
    const numStrFractionIndex = numStr.indexOf(".");
    const exponentStr = split[4];
    let exponent = parseInt(exponentStr) * (split[3] === "-" ? -1 : 1);
    if (numStrFractionIndex >= 0) {
        const fractionLen = numStr.length - numStrFractionIndex - 1;
        exponent = exponent - fractionLen;
        numStr = removeHeadZeros(numStr.replace(".", ""));
    }
    const prefix = isNeg ? "-" : "";
    if (exponent < 0) {
        if (numStr.length > -exponent) {
            const fractionPosition = numStr.length + exponent;
            return (prefix +
                (numStr.slice(0, fractionPosition) +
                    "." +
                    numStr.slice(fractionPosition)));
        }
        return prefix + "0." + makeZerosStr(-(numStr.length + exponent)) + numStr;
    }
    else {
        return prefix + numStr + makeZerosStr(exponent);
    }
}
exports.exponentDecStringToDecString = exponentDecStringToDecString;
//# sourceMappingURL=etc.js.map