import { Dec } from "./decimal";
import { DeepReadonly } from "utility-types";
import bigInteger from "big-integer";
export declare type IntPrettyOptions = {
    maxDecimals: number;
    trim: boolean;
    shrink: boolean;
    ready: boolean;
    locale: boolean;
    inequalitySymbol: boolean;
    inequalitySymbolSeparator: string;
};
export declare class IntPretty {
    protected dec: Dec;
    protected floatingDecimalPointRight: number;
    protected _options: IntPrettyOptions;
    constructor(num: Dec | {
        toDec(): Dec;
    } | bigInteger.BigNumber);
    get options(): DeepReadonly<IntPrettyOptions>;
    moveDecimalPointLeft(delta: number): IntPretty;
    moveDecimalPointRight(delta: number): IntPretty;
    /**
     * @deprecated Use`moveDecimalPointLeft`
     */
    increasePrecision(delta: number): IntPretty;
    /**
     * @deprecated Use`moveDecimalPointRight`
     */
    decreasePrecision(delta: number): IntPretty;
    maxDecimals(max: number): IntPretty;
    inequalitySymbol(bool: boolean): IntPretty;
    inequalitySymbolSeparator(str: string): IntPretty;
    trim(bool: boolean): IntPretty;
    shrink(bool: boolean): IntPretty;
    locale(locale: boolean): IntPretty;
    /**
     * Ready indicates the actual value is ready to show the users.
     * Even if the ready option is false, it expects that the value can be shown to users (probably as 0).
     * The method that returns prettied value may return `undefined` or `null` if the value is not ready.
     * But, alternatively, it can return the 0 value that can be shown the users anyway, but indicates that the value is not ready.
     * @param bool
     */
    ready(bool: boolean): IntPretty;
    get isReady(): boolean;
    add(target: Dec | {
        toDec(): Dec;
    }): IntPretty;
    sub(target: Dec | {
        toDec(): Dec;
    }): IntPretty;
    mul(target: Dec | {
        toDec(): Dec;
    }): IntPretty;
    quo(target: Dec | {
        toDec(): Dec;
    }): IntPretty;
    toDec(): Dec;
    toString(): string;
    toStringWithSymbols(prefix: string, suffix: string): string;
    clone(): IntPretty;
}
