"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatePretty = void 0;
const int_pretty_1 = require("./int-pretty");
/**
 * RatePretty treats `Dec` in rate form for easy calculation, and displays it as a percentage to the user by using toString().
 * By default, if the value is less than maxDeciamls, it is displayed using an inequality sign (Ex. < 0.001%)
 */
class RatePretty {
    constructor(amount) {
        this.amount = amount;
        this._options = {
            separator: "",
            symbol: "%",
        };
        this.intPretty = new int_pretty_1.IntPretty(amount);
        this.intPretty = this.intPretty
            .maxDecimals(3)
            .shrink(false)
            .trim(true)
            .locale(true)
            .inequalitySymbol(true);
    }
    get options() {
        return Object.assign(Object.assign({}, this.intPretty.options), this._options);
    }
    separator(str) {
        const pretty = this.clone();
        pretty._options.separator = str;
        return pretty;
    }
    symbol(str) {
        const pretty = this.clone();
        pretty._options.symbol = str;
        return pretty;
    }
    moveDecimalPointLeft(delta) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.moveDecimalPointLeft(delta);
        return pretty;
    }
    moveDecimalPointRight(delta) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.moveDecimalPointRight(delta);
        return pretty;
    }
    maxDecimals(max) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.maxDecimals(max);
        return pretty;
    }
    inequalitySymbol(bool) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.inequalitySymbol(bool);
        return pretty;
    }
    inequalitySymbolSeparator(str) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.inequalitySymbolSeparator(str);
        return pretty;
    }
    trim(bool) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.trim(bool);
        return pretty;
    }
    shrink(bool) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.shrink(bool);
        return pretty;
    }
    locale(locale) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.locale(locale);
        return pretty;
    }
    /**
     * Ready indicates the actual value is ready to show the users.
     * Even if the ready option is false, it expects that the value can be shown to users (probably as 0).
     * The method that returns prettied value may return `undefined` or `null` if the value is not ready.
     * But, alternatively, it can return the 0 value that can be shown the users anyway, but indicates that the value is not ready.
     * @param bool
     */
    ready(bool) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.ready(bool);
        return pretty;
    }
    get isReady() {
        return this.intPretty.isReady;
    }
    add(target) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.add(target);
        return pretty;
    }
    sub(target) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.sub(target);
        return pretty;
    }
    mul(target) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.mul(target);
        return pretty;
    }
    quo(target) {
        const pretty = this.clone();
        pretty.intPretty = pretty.intPretty.quo(target);
        return pretty;
    }
    toDec() {
        return this.intPretty.toDec();
    }
    toString() {
        return this.intPretty
            .moveDecimalPointRight(2)
            .toStringWithSymbols("", `${this._options.separator}${this._options.symbol}`);
    }
    clone() {
        const pretty = new RatePretty(this.amount);
        pretty._options = Object.assign({}, this._options);
        pretty.intPretty = this.intPretty.clone();
        return pretty;
    }
}
exports.RatePretty = RatePretty;
//# sourceMappingURL=rate-pretty.js.map