"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadBinding = void 0;
const fs_1 = require("fs");
const os_1 = require("os");
const path_1 = require("path");
const triples_1 = require("@napi-rs/triples");
const ArchName = (0, os_1.arch)();
const PlatformName = (0, os_1.platform)();
function loadBinding(dirname, filename = 'index', packageName) {
    var _a, _b;
    const triples = triples_1.platformArchTriples[PlatformName][ArchName];
    let additionalErrorMsg = '';
    for (const triple of triples) {
        if (packageName) {
            try {
                return require(require.resolve(`${packageName}-${triple.platformArchABI}`, { paths: [dirname] }));
            }
            catch (e) {
                if ((e === null || e === void 0 ? void 0 : e.code) !== 'MODULE_NOT_FOUND') {
                    try {
                        const pkgPath = require.resolve(`${packageName}-${triple.platformArchABI}`, { paths: [dirname] });
                        additionalErrorMsg += `file: ${pkgPath} existed but error occurred while require it: ${(_a = e.message) !== null && _a !== void 0 ? _a : e} \n`;
                    }
                    catch (_c) { }
                }
            }
        }
        const localFilePath = (0, path_1.join)(dirname, `${filename}.${triple.platformArchABI}.node`);
        if ((0, fs_1.existsSync)(localFilePath)) {
            try {
                return require(localFilePath);
            }
            catch (e) {
                additionalErrorMsg += `file: ${localFilePath} existed but error occurred while require it: ${(_b = e.message) !== null && _b !== void 0 ? _b : e} \n`;
            }
        }
    }
    let packageList = '';
    if (packageName) {
        try {
            const packageNameWithoutNamespace = packageName.split('/').pop();
            packageList = (0, fs_1.readdirSync)((0, path_1.join)(require.resolve(packageName, { paths: [dirname] }), '..', '..'))
                .filter((d) => d !== packageNameWithoutNamespace && d.startsWith(packageNameWithoutNamespace))
                .join(', ');
        }
        catch (_d) { }
    }
    const errorMsg = `Can not load bindings${additionalErrorMsg ? ', ' + additionalErrorMsg : '\n'}${packageList ? 'Installed packages: [' + packageList + ']' : ''}`;
    throw new Error(errorMsg);
}
exports.loadBinding = loadBinding;
