"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var ts = require("typescript");
var fs = require("fs");
var path_1 = require("path");
function handleDiagnostics(type, diagnostics, bail) {
    if (bail === void 0) { bail = false; }
    var e_1, _a;
    var ret = [];
    try {
        for (var diagnostics_1 = __values(diagnostics), diagnostics_1_1 = diagnostics_1.next(); !diagnostics_1_1.done; diagnostics_1_1 = diagnostics_1.next()) {
            var diagnostic = diagnostics_1_1.value;
            var parts = [type + ":"];
            if (diagnostic.file && diagnostic.start != null) {
                var _b = diagnostic.file.getLineAndCharacterOfPosition(diagnostic.start), line = _b.line, character = _b.character;
                parts.push("" + diagnostic.file.fileName, "(" + (line + 1) + ", " + (character + 1) + ")");
            }
            var message = ts.flattenDiagnosticMessageText(diagnostic.messageText, '\n');
            parts.push(message);
            var text = parts.join(' ');
            if (bail)
                throw new Error(text);
            ret.push(text);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (diagnostics_1_1 && !diagnostics_1_1.done && (_a = diagnostics_1.return)) _a.call(diagnostics_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return ret;
}
function findLastNodeComment(node) {
    var text = node.getFullText();
    var commentRanges = ts.getLeadingCommentRanges(node.getFullText(), 0);
    if (commentRanges == null || commentRanges.length === 0) {
        return '';
    }
    var _a = commentRanges[commentRanges.length - 1], pos = _a.pos, end = _a.end;
    return text.substring(pos, end);
}
function forEachExpectedFailureNodes(node, cb) {
    if (node.kind !== ts.SyntaxKind.SourceFile &&
        findLastNodeComment(node).match(/^\/[\/*] typings:expect-error/)) {
        cb(node);
    }
    else {
        ts.forEachChild(node, function (child) {
            forEachExpectedFailureNodes(child, cb);
        });
    }
}
function check(files, tsConfigPath, bail) {
    if (bail === void 0) { bail = false; }
    var e_2, _a, e_3, _b;
    var _c = ts.readConfigFile(tsConfigPath, ts.sys.readFile), config = _c.config, error = _c.error;
    if (error) {
        throw new Error(ts.flattenDiagnosticMessageText(error.messageText, '\n'));
    }
    var _d = ts.convertCompilerOptionsFromJson(config.compilerOptions, path_1.dirname(tsConfigPath)), options = _d.options, errors = _d.errors;
    if (errors.length > 0) {
        throw new Error(ts.flattenDiagnosticMessageText(errors[0].messageText, '\n'));
    }
    var allErrors = [];
    try {
        for (var files_1 = __values(files), files_1_1 = files_1.next(); !files_1_1.done; files_1_1 = files_1.next()) {
            var file = files_1_1.value;
            if (!fs.existsSync(file)) {
                throw new Error("File '" + file + "' not found.");
            }
            var program = ts.createProgram([file], options);
            var global_1 = handleDiagnostics('Global', program.getGlobalDiagnostics(), bail);
            var syntax = handleDiagnostics('Syntactic', program.getSyntacticDiagnostics(), bail);
            allErrors.push.apply(allErrors, __spread(global_1, syntax));
            var _loop_1 = function (sourceFile) {
                var semantic = program.getSemanticDiagnostics(sourceFile);
                var rootFileNames = program.getRootFileNames().map(path_1.normalize);
                var fileName = path_1.normalize(sourceFile.fileName);
                if (rootFileNames.indexOf(fileName) !== -1) {
                    forEachExpectedFailureNodes(sourceFile, function (node) {
                        var e_4, _a;
                        var failures = [];
                        var leftSemantics = [];
                        try {
                            for (var semantic_1 = __values(semantic), semantic_1_1 = semantic_1.next(); !semantic_1_1.done; semantic_1_1 = semantic_1.next()) {
                                var diag = semantic_1_1.value;
                                if (diag.start != null &&
                                    diag.length != null &&
                                    node.pos <= diag.start &&
                                    diag.start + diag.length <= node.end) {
                                    failures.push(diag);
                                }
                                else {
                                    leftSemantics.push(diag);
                                }
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (semantic_1_1 && !semantic_1_1.done && (_a = semantic_1.return)) _a.call(semantic_1);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                        if (failures.length === 0) {
                            var _b = sourceFile.getLineAndCharacterOfPosition(node.getStart()), line = _b.line, character = _b.character;
                            var message = "Expected error: " + sourceFile.fileName + " " +
                                ("(" + (line + 1) + ", " + (character + 1) + "):\n") +
                                node.getText();
                            if (bail)
                                throw new Error(message);
                            allErrors.push(message);
                        }
                        semantic = leftSemantics;
                    });
                }
                allErrors.push.apply(allErrors, __spread(handleDiagnostics('Semantic', semantic, bail)));
            };
            try {
                for (var _e = __values(program.getSourceFiles()), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var sourceFile = _f.value;
                    _loop_1(sourceFile);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (files_1_1 && !files_1_1.done && (_a = files_1.return)) _a.call(files_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    if (allErrors.length > 0)
        throw new Error(allErrors.join('\n\n'));
}
exports.check = check;
function checkDirectory(path, bail) {
    if (bail === void 0) { bail = false; }
    var files = ts.sys.readDirectory(path, ['.ts', '.tsx']);
    var tsConfigPath = ts.findConfigFile(path, ts.sys.fileExists);
    if (!tsConfigPath) {
        throw new Error("Cannot find TypeScript config file in " + path + ".");
    }
    check(files, tsConfigPath, bail);
}
exports.checkDirectory = checkDirectory;
