import * as nacl from 'tweetnacl';
import type { uint8 } from '@spliterati/uint8';
export declare module Signed {
    class Shard {
        readonly keyID: Uint8Array;
        readonly t: uint8;
        readonly n: uint8;
        readonly share: Uint8Array;
        static readonly KEYID_LENGTH = 16;
        constructor(keyID: Uint8Array, t: uint8, n: uint8, share: Uint8Array);
        pack(): Uint8Array;
        static unpack(bytes: Uint8Array | null, isSigned?: boolean): (Shard | null);
        metadataEqual(that: Shard): boolean;
    }
    function generate(t: uint8, n: uint8, opts?: {
        message?: Uint8Array;
        keyID?: Uint8Array;
    }): {
        signingPublicKey: Uint8Array;
        encryptionPublicKey: Uint8Array;
        keyID: Uint8Array;
        shards: Uint8Array[];
        signedMessage: Uint8Array | null;
    };
    function reconstruct(signingPublicKey: Uint8Array, shards: Uint8Array[]): {
        keyID: Uint8Array;
        encryptionKeyPair: nacl.BoxKeyPair;
    };
}
