"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Slicer = exports.Uint8ArrayEqual = void 0;
const random_js_1 = require("random-js");
const random = new random_js_1.Random();
function Uint8ArrayEqual(a, b) {
    let one;
    let two;
    [one, two] = a.length < b.length ? [a, b] : [b, a];
    return one.reduce((bs, val, i) => bs | (two[i] ^ val), a.length ^ b.length) === 0;
}
exports.Uint8ArrayEqual = Uint8ArrayEqual;
class Slicer {
    constructor(data) {
        this.data = data;
        this.index = 0;
    }
    next(amt) {
        let end;
        switch (amt) {
            case undefined:
                return this.data[this.index++];
            case 'end':
                break;
            default:
                end = this.index + amt;
                break;
        }
        const slice = this.data.slice(this.index, end);
        this.index = (amt == 'end' ? this.data.length : end);
        return slice;
    }
}
exports.Slicer = Slicer;
function takeNRandom(n, elements) {
    if (n > elements.length) {
        throw new SyntaxError('cannot take more elements than there are');
    }
    else if (n < 0) {
        throw new SyntaxError('cannot return a negative number of elements');
    }
    switch (n) {
        case 0:
            return [];
        case 1:
            return [elements[random.integer(0, elements.length)]];
        default:
    }
    const shuf = random.shuffle([...elements]);
    return shuf.slice(0, n);
}
exports.default = takeNRandom;
//# sourceMappingURL=utils.js.map