# Installation
> `npm install --save @types/css-modules-loader-core`

# Summary
This package contains type definitions for css-modules-loader-core (https://github.com/css-modules/css-modules-loader-core).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/css-modules-loader-core.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/css-modules-loader-core/index.d.ts)
````ts
import { Plugin } from "postcss";

declare namespace Core {
    type Source =
        | string
        | {
            toString(): string;
        };

    type PathFetcher = (
        file: string,
        relativeTo: string,
        depTrace: string,
    ) => void;

    interface ExportTokens {
        [index: string]: string;
    }

    interface Result {
        injectableSource: string;
        exportTokens: ExportTokens;
    }
}

declare class Core {
    static values: Plugin<{}>;
    static localByDefault: Plugin<{}>;
    static extractImports: Plugin<{}>;
    static scope: Plugin<{}>;
    static defaultPlugins: Array<Plugin<{}>>;

    constructor(plugins?: Array<Plugin<any>>);

    load(
        source: Core.Source,
        sourcePath?: string,
        trace?: string,
        pathFetcher?: Core.PathFetcher,
    ): Promise<Core.Result>;
}

export = Core;
export as namespace Core;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: [postcss](https://npmjs.com/package/postcss)

# Credits
These definitions were written by [Spencer Miskoviak](https://github.com/skovy).
