# Installation
> `npm install --save @types/xmldom`

# Summary
This package contains type definitions for xmldom (https://github.com/xmldom/xmldom).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/xmldom.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/xmldom/index.d.ts)
````ts
/// <reference lib="dom" />

declare namespace xmldom {
    var DOMParser: DOMParserStatic;
    var XMLSerializer: XMLSerializerStatic;
    var DOMImplementation: DOMImplementationStatic;

    interface DOMImplementationStatic {
        new(): DOMImplementation;
    }

    interface DOMParserStatic {
        new(): DOMParser;
        new(options: Options): DOMParser;
    }

    interface XMLSerializerStatic {
        new(): XMLSerializer;
    }

    interface DOMParser {
        parseFromString(xmlsource: string, mimeType?: string): Document;
    }

    interface XMLSerializer {
        serializeToString(node: Node): string;
    }

    interface Options {
        locator?: any;
        errorHandler?: ErrorHandlerFunction | ErrorHandlerObject | undefined;
    }

    interface ErrorHandlerFunction {
        (level: string, msg: any): any;
    }

    interface ErrorHandlerObject {
        warning?: ((msg: any) => any) | undefined;
        error?: ((msg: any) => any) | undefined;
        fatalError?: ((msg: any) => any) | undefined;
    }
}

export = xmldom;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 15:11:36 GMT
 * Dependencies: none

# Credits
These definitions were written by [Qubo](https://github.com/tkqubo), and [Karfau](https://github.com/karfau).
