"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Renames the keys of a `Files` map.
 *
 * @param files A map of filenames to `File` instances
 * @param delegate A function that returns the new filename
 * @returns A new file map with the renamed filenames
 */
function rename(files, delegate) {
    const result = {};
    for (const [name, file] of Object.entries(files)) {
        result[delegate(name)] = file;
    }
    return result;
}
exports.default = rename;
