"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildsSchema = exports.functionsSchema = void 0;
exports.functionsSchema = {
    type: 'object',
    minProperties: 1,
    maxProperties: 50,
    additionalProperties: false,
    patternProperties: {
        '^.{1,256}$': {
            type: 'object',
            additionalProperties: false,
            properties: {
                runtime: {
                    type: 'string',
                    maxLength: 256,
                },
                memory: {
                    minimum: 128,
                    maximum: 3008,
                },
                maxDuration: {
                    type: 'number',
                    minimum: 1,
                    maximum: 900,
                },
                includeFiles: {
                    type: 'string',
                    maxLength: 256,
                },
                excludeFiles: {
                    type: 'string',
                    maxLength: 256,
                },
            },
        },
    },
};
exports.buildsSchema = {
    type: 'array',
    minItems: 0,
    maxItems: 128,
    items: {
        type: 'object',
        additionalProperties: false,
        required: ['use'],
        properties: {
            src: {
                type: 'string',
                minLength: 1,
                maxLength: 4096,
            },
            use: {
                type: 'string',
                minLength: 3,
                maxLength: 256,
            },
            config: { type: 'object' },
        },
    },
};
