"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateVercelBuildOutputAPI3Output = void 0;
const path_1 = require("path");
const routing_utils_1 = require("@vercel/routing-utils");
const fs_extra_1 = require("fs-extra");
const schemas_1 = require("./schemas");
const functions_1 = require("./helpers/functions");
const static_1 = require("./helpers/static");
async function generateVercelBuildOutputAPI3Output({ exportPath, gatsbyStoreState, }) {
    const state = {
        pages: Array.from(gatsbyStoreState.pages.entries()),
        redirects: gatsbyStoreState.redirects,
        functions: gatsbyStoreState.functions,
        config: gatsbyStoreState.config,
    };
    if (schemas_1.validateGatsbyState(state)) {
        console.log('▲ Creating Vercel build output');
        await fs_extra_1.remove(path_1.join('.vercel', 'output'));
        const { pages, redirects, functions, config: gatsbyConfig } = state;
        const ssrRoutes = pages
            .map(p => p[1])
            .filter(page => page.mode === 'SSR' || page.mode === 'DSG');
        const ops = [static_1.createStaticDir(gatsbyConfig.pathPrefix)];
        if (functions.length > 0) {
            ops.push(functions_1.createAPIRoutes(functions, gatsbyConfig.pathPrefix));
        }
        if (ssrRoutes.length > 0) {
            ops.push(functions_1.createServerlessFunctions(ssrRoutes, gatsbyConfig.pathPrefix));
        }
        await Promise.all(ops);
        let trailingSlash = undefined;
        if (gatsbyConfig.trailingSlash === 'always') {
            trailingSlash = true;
        }
        else if (gatsbyConfig.trailingSlash === 'never') {
            trailingSlash = false;
        }
        const { routes } = routing_utils_1.getTransformedRoutes({
            trailingSlash,
            redirects: redirects.map(({ fromPath, toPath, isPermanent }) => ({
                source: fromPath,
                destination: toPath,
                permanent: isPermanent,
            })),
        });
        const config = {
            version: 3,
            routes: routes || undefined,
        };
        await fs_extra_1.writeJson(exportPath, config);
        console.log('Vercel output has been generated');
    }
    else {
        throw new Error('Gatsby state validation error. Please file an issue https://vercel.com/help#issues');
    }
}
exports.generateVercelBuildOutputAPI3Output = generateVercelBuildOutputAPI3Output;
//# sourceMappingURL=index.js.map