"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateGatsbyState = exports.ajv = void 0;
const ajv_1 = __importDefault(require("ajv"));
const GatsbyPageSchema = {
    type: 'object',
    properties: {
        mode: {
            type: 'string',
            enum: ['SSG', 'DSG', 'SSR'],
        },
        path: {
            type: 'string',
        },
    },
    required: ['mode', 'path'],
};
const GatsbyFunctionSchema = {
    type: 'object',
    properties: {
        functionRoute: { type: 'string' },
        originalAbsoluteFilePath: { type: 'string' },
    },
    required: ['functionRoute', 'originalAbsoluteFilePath'],
};
const GatsbyRedirectSchema = {
    type: 'object',
    properties: {
        fromPath: { type: 'string' },
        toPath: { type: 'string' },
        isPermanent: { type: 'boolean', nullable: true },
    },
    required: ['fromPath', 'toPath'],
};
const GatsbyConfigSchema = {
    type: 'object',
    properties: {
        trailingSlash: {
            type: 'string',
            enum: ['always', 'never', 'ignore', 'legacy'],
            nullable: true,
        },
        assetPrefix: {
            type: 'string',
            nullable: true,
        },
        pathPrefix: {
            type: 'string',
            nullable: true,
        },
    },
};
const GatsbyStateSchema = {
    type: 'object',
    properties: {
        pages: {
            type: 'array',
            items: {
                type: 'array',
                minItems: 2,
                maxItems: 2,
                items: [{ type: 'string' }, GatsbyPageSchema],
            },
        },
        redirects: {
            type: 'array',
            items: GatsbyRedirectSchema,
        },
        functions: {
            type: 'array',
            items: GatsbyFunctionSchema,
        },
        config: GatsbyConfigSchema,
    },
    required: ['pages', 'redirects', 'functions', 'config'],
    additionalProperties: true,
};
exports.ajv = new ajv_1.default({ allErrors: true });
exports.validateGatsbyState = exports.ajv.compile(GatsbyStateSchema);
//# sourceMappingURL=schemas.js.map