"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = __importDefault(require("os"));
const etag_1 = __importDefault(require("etag"));
const url_1 = require("url");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const utils_1 = require("../utils");
const TMP_DATA_PATH = (0, path_1.join)(os_1.default.tmpdir(), 'data/datastore');
const CUR_DATA_PATH = (0, path_1.join)(__dirname, '.cache/data/datastore');
if (!(0, fs_extra_1.existsSync)(TMP_DATA_PATH)) {
    // Copies executable `data` files to the writable /tmp directory.
    (0, fs_extra_1.copySync)(CUR_DATA_PATH, TMP_DATA_PATH);
}
async function handler(req, res) {
    let pageName;
    const pathname = (0, url_1.parse)(req.url).pathname || '/';
    const isPageData = pathname.startsWith('/page-data/');
    if (isPageData) {
        // /page-data/index/page-data.json
        // /page-data/using-ssr/page-data.json
        pageName = (0, path_1.basename)((0, path_1.dirname)(pathname));
        if (pageName === 'index') {
            pageName = '/';
        }
    }
    else {
        // /using-ssr
        // /using-ssr/
        // /using-ssr/index.html
        pageName = (0, path_1.basename)(pathname);
        if (pageName === 'index.html') {
            pageName = (0, path_1.basename)((0, path_1.dirname)(pathname));
        }
        if (!pageName) {
            pageName = '/';
        }
    }
    const [graphqlEngine, { getData, renderHTML, renderPageData }] = await Promise.all([(0, utils_1.getGraphQLEngine)(), (0, utils_1.getPageSSRHelpers)()]);
    const data = await getData({
        pathName: pageName,
        graphqlEngine,
        req,
    });
    const results = isPageData
        ? await renderPageData({ data })
        : await renderHTML({ data });
    if (data.serverDataHeaders) {
        for (const [name, value] of Object.entries(data.serverDataHeaders)) {
            res.setHeader(name, value);
        }
    }
    if (data.serverDataStatus) {
        res.statusCode = data.serverDataStatus;
    }
    if (isPageData) {
        res.setHeader('ETag', (0, etag_1.default)(JSON.stringify(results)));
        res.json(results);
    }
    else {
        res.send(results);
    }
}
exports.default = handler;
//# sourceMappingURL=ssr-handler.js.map