"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateGatsbyState = void 0;
const typebox_1 = require("@sinclair/typebox");
const custom_1 = require("@sinclair/typebox/custom");
const compiler_1 = require("@sinclair/typebox/compiler");
custom_1.Custom.Set('StringEnum', (schema, value) => {
    return schema.enum.includes(value);
});
function StringEnum(values) {
    return typebox_1.Type.Unsafe({
        [typebox_1.Kind]: 'StringEnum',
        type: 'string',
        enum: values,
    });
}
const GatsbyPageSchema = typebox_1.Type.Object({
    mode: StringEnum(['SSG', 'DSG', 'SSR']),
    path: typebox_1.Type.String(),
});
const GatsbyFunctionSchema = typebox_1.Type.Object({
    functionRoute: typebox_1.Type.String(),
    originalAbsoluteFilePath: typebox_1.Type.String(),
});
compiler_1.TypeCompiler.Compile(GatsbyFunctionSchema);
const GatsbyRedirectSchema = typebox_1.Type.Object({
    fromPath: typebox_1.Type.String(),
    toPath: typebox_1.Type.String(),
    isPermanent: typebox_1.Type.Optional(typebox_1.Type.Boolean()),
});
const GatsbyConfigSchema = typebox_1.Type.Object({
    trailingSlash: typebox_1.Type.Optional(StringEnum(['always', 'never', 'ignore', 'legacy'])),
    pathPrefix: typebox_1.Type.Optional(typebox_1.Type.String()),
});
const GatsbyStateSchema = typebox_1.Type.Object({
    pages: typebox_1.Type.Array(typebox_1.Type.Tuple([typebox_1.Type.String(), GatsbyPageSchema])),
    redirects: typebox_1.Type.Array(GatsbyRedirectSchema),
    functions: typebox_1.Type.Array(GatsbyFunctionSchema),
    config: GatsbyConfigSchema,
});
exports.validateGatsbyState = compiler_1.TypeCompiler.Compile(GatsbyStateSchema);
//# sourceMappingURL=schemas.js.map