/// <reference types="node" />
/// <reference types="node" />
import type { ConfigRoute, RouteManifest } from '@remix-run/dev/dist/config/routes';
import type { RemixConfig } from '@remix-run/dev/dist/config';
import type { BaseFunctionConfig } from '@vercel/static-config';
import type { CliType, SpawnOptionsExtended } from '@vercel/build-utils/dist/fs/run-user-scripts';
export declare const _require: typeof require;
export interface ResolvedNodeRouteConfig {
    runtime: 'nodejs';
    regions?: string[];
    maxDuration?: number;
    memory?: number;
}
export interface ResolvedEdgeRouteConfig {
    runtime: 'edge';
    regions?: BaseFunctionConfig['regions'];
}
export type ResolvedRouteConfig = ResolvedNodeRouteConfig | ResolvedEdgeRouteConfig;
export interface ResolvedRoutePaths {
    /**
     * The full URL path of the route, as will be shown
     * on the Functions tab in the deployment inspector.
     */
    path: string;
    /**
     * The full URL path of the route, but with syntax that
     * is compatible with the `path-to-regexp` module.
     */
    rePath: string;
}
export declare function findEntry(dir: string, basename: string): string | undefined;
export declare function findConfig(dir: string, basename: string): string | undefined;
export declare function getResolvedRouteConfig(route: ConfigRoute, routes: RouteManifest, configs: Map<ConfigRoute, BaseFunctionConfig | null>): ResolvedRouteConfig;
export declare function calculateRouteConfigHash(config: ResolvedRouteConfig): string;
export declare function isLayoutRoute(routeId: string, routes: Pick<ConfigRoute, 'id' | 'parentId'>[]): boolean;
export declare function getRouteIterator(route: ConfigRoute, routes: RouteManifest): Generator<ConfigRoute, void, unknown>;
export declare function getPathFromRoute(route: ConfigRoute, routes: RouteManifest): ResolvedRoutePaths;
export declare function getRegExpFromPath(rePath: string): RegExp | false;
/**
 * Updates the `dest` process.env object to match the `source` one.
 * A function is returned to restore the the `dest` env back to how
 * it was originally.
 */
export declare function syncEnv(source: NodeJS.ProcessEnv, dest: NodeJS.ProcessEnv): () => any;
export declare function chdirAndReadConfig(remixRunDevPath: string, dir: string, packageJsonPath: string): Promise<RemixConfig>;
export interface AddDependenciesOptions extends SpawnOptionsExtended {
    saveDev?: boolean;
}
/**
 * Runs `npm i ${name}` / `pnpm i ${name}` / `yarn add ${name}`.
 */
export declare function addDependencies(cliType: CliType, names: string[], opts?: AddDependenciesOptions): Promise<void>;
export declare function resolveSemverMinMax(min: string, max: string, version: string): string;
export declare function ensureResolvable(start: string, base: string, pkgName: string): Promise<string>;
export declare function isESM(path: string): boolean;
