### Changelog

All notable changes to this project will be documented in this file.

#### [v3.0.1](https://github.com/missive/emoji-mart/compare/v3.0.0...v3.0.1)

> February 24 2020

##### Fixes 🐛
- Safely access search input #419
- Custom category aria-label #480

##### Chores 🧹
- React v17 support #475

#### [v3.0.0](https://github.com/missive/emoji-mart/compare/v2.11.2...v3.0.0)

> March 16 2020

##### New 🎉
- [Emoji 12.1](https://emojipedia.org/emoji-12.1) 👩‍🦳👨‍🦰🦾 [`#411`](https://github.com/missive/emoji-mart/pull/411)
- Option to disable use of `<button>` in Picker [`17cf50f`](https://github.com/missive/emoji-mart/commit/17cf50f7bafbbd2dbff9cabe0737e457a8aa1e72)

##### Breaking 🚨
- As part of the Emoji 12.1 support and the upgrade of our data provider, `emojione` is no longer available [`emoji-data/142`](https://github.com/iamcal/emoji-data/pull/142)
- `messenger` has been removed. Facebook has unified their emojis and is no longer mainting a different set for Messenger. Use `facebook` instead [`emoji-data/165#issuecomment-572795078`](https://github.com/iamcal/emoji-data/pull/165#issuecomment-572795078)
- `darkMode` Picker prop superseded by `theme`. Defaults to `light` [`d1138c0`](https://github.com/missive/emoji-mart/commit/d1138c00e8d2e79c990ea75b89aaea4c7e819c7b)
- No more auto-sorting of the “Frequently used” category. Use `enableFrequentEmojiSort` to enable [`#417`](https://github.com/missive/emoji-mart/pull/417)

##### Fixes 🐛
- Horizontal scoll overflow [`#410`](https://github.com/missive/emoji-mart/pull/410)

##### Chores 🧹
- Remove core-js dependency [`#394`](https://github.com/missive/emoji-mart/pull/394)
- Upgrade to Babel V7 [`#397`](https://github.com/missive/emoji-mart/pull/397)
- Remove _JSON hack [`#401`](https://github.com/missive/emoji-mart/pull/401)
- Remove rAF polyfill [`#402`](https://github.com/missive/emoji-mart/pull/402)

#### [v2.11.2](https://github.com/missive/emoji-mart/compare/v2.11.1...v2.11.2)

> 23 December 2019

- chore(deps): bump lodash from 4.17.11 to 4.17.15 [`#390`](https://github.com/missive/emoji-mart/pull/390)
- chore(deps): bump handlebars from 4.1.0 to 4.5.3 [`#389`](https://github.com/missive/emoji-mart/pull/389)
- chore(deps): bump lodash-es from 4.17.11 to 4.17.15 [`#388`](https://github.com/missive/emoji-mart/pull/388)
- chore(deps): bump mixin-deep from 1.3.1 to 1.3.2 [`#387`](https://github.com/missive/emoji-mart/pull/387)
- fix: gracefully ignore bad JSON in localstorage [`#385`](https://github.com/missive/emoji-mart/pull/385)
- docs: Move `With custom data` to correct position [`#377`](https://github.com/missive/emoji-mart/pull/377)
- fix: Use getDerivedStateFromProps instead of componentWillReceiveProps [`#372`](https://github.com/missive/emoji-mart/pull/372)
- fix: Ensure emoji backgrounds do not tile [`#362`](https://github.com/missive/emoji-mart/pull/362)
- Fix: Allowing emoji selection on enter [`#386`](https://github.com/missive/emoji-mart/pull/386)
- fix: ensure unique keys for React list [`#352`](https://github.com/missive/emoji-mart/pull/352)
- fix: Deterministic sorting of search results. [`#343`](https://github.com/missive/emoji-mart/pull/343)
- docs: document how to remove the footer [`#330`](https://github.com/missive/emoji-mart/pull/330)
- test: add basic skins test [`#315`](https://github.com/missive/emoji-mart/pull/315)
- docs: Add tip for l10n to use CLDR [`#344`](https://github.com/missive/emoji-mart/pull/344)
- Add support for more than one custom category [`#224`](https://github.com/missive/emoji-mart/issues/224)
- Update gh-pages [`ff9d416`](https://github.com/missive/emoji-mart/commit/ff9d416300e30a6bb14262066cb1a63f9790c336)
- Add theme selection to gh-pages [`e66be9d`](https://github.com/missive/emoji-mart/commit/e66be9dc4efb753b26ecaaf8583392e83c933b9c)
- fix: dark mode CSS tweaks, add storybook/matchMedia/docs [`8cff39f`](https://github.com/missive/emoji-mart/commit/8cff39f6fd7add3a15ba7695bc117fe4794d3688)

#### [v2.11.1](https://github.com/missive/emoji-mart/compare/v2.11.0...v2.11.1)

> 9 May 2019

- Added `type={"button"}` to anchors.js [`#338`](https://github.com/missive/emoji-mart/pull/338)
- Update gh-pages [`f654ef4`](https://github.com/missive/emoji-mart/commit/f654ef4050dd8fe4e06af96818bbddebcf8c4650)
- Release v2.11.1 [`ae24948`](https://github.com/missive/emoji-mart/commit/ae24948861119f4cd366ad9432f74afff5cfddff)
- attempt 2 to fix prettier error [`af37a7a`](https://github.com/missive/emoji-mart/commit/af37a7a20f66f172ef6f8e75dbcd59d36a91df05)

#### [v2.11.0](https://github.com/missive/emoji-mart/compare/v2.10.0...v2.11.0)

> 28 March 2019

- fix: use span for non-clickable emojis [`#329`](https://github.com/missive/emoji-mart/pull/329)
- docs: fix travis CI badge [`#316`](https://github.com/missive/emoji-mart/pull/316)
- fix: consistently return short_names from sanitize [`#317`](https://github.com/missive/emoji-mart/pull/317)
- test: add test for short_names in custom emoji [`#323`](https://github.com/missive/emoji-mart/pull/323)
- Get emoji data from native [`#250`](https://github.com/missive/emoji-mart/pull/250)
- Fix typo [`#324`](https://github.com/missive/emoji-mart/pull/324)
- Return skin emoji on search [`#321`](https://github.com/missive/emoji-mart/pull/321)
- Add ignore for package-lock.json [`#322`](https://github.com/missive/emoji-mart/pull/322)
- Add .editorconfig [`#320`](https://github.com/missive/emoji-mart/pull/320)
- chore: add Travis CI tests [`#306`](https://github.com/missive/emoji-mart/pull/306)
- keep short_names on sanitize [`#308`](https://github.com/missive/emoji-mart/pull/308)
- docs: add example of how to use outside React [`#307`](https://github.com/missive/emoji-mart/pull/307)
- docs: add example of how to use outside React [`#305`](https://github.com/missive/emoji-mart/issues/305)
- Return emojis with skin tone from store on nimble search [`51a0879`](https://github.com/missive/emoji-mart/commit/51a0879ec17fa30bcdd0be3ea39c50af067e86ec)
- Delete package-lock.json [`aaa12fe`](https://github.com/missive/emoji-mart/commit/aaa12fe9183f4b30cc483380f4e923ab2b9bd91a)
- Upgrade some dev dependencies [`d739f27`](https://github.com/missive/emoji-mart/commit/d739f27714c4b1e28f3d92f654a5ba83933c2816)

#### [v2.10.0](https://github.com/missive/emoji-mart/compare/v2.9.2...v2.10.0)

> 15 March 2019

- chore: fix prettier linting [`#304`](https://github.com/missive/emoji-mart/pull/304)
- test: replace karma with jest [`#302`](https://github.com/missive/emoji-mart/pull/302)
- chore: `yarn clean` should remove dist-modern [`#301`](https://github.com/missive/emoji-mart/pull/301)
- fix: improve requestIdleCallback usage [`#300`](https://github.com/missive/emoji-mart/pull/300)
- fix: make each emoji category into a list [`#299`](https://github.com/missive/emoji-mart/pull/299)
- chore: fix custom emoji URLs in storybook [`#298`](https://github.com/missive/emoji-mart/pull/298)
- fix: improve a11y of skin tone picker [`#297`](https://github.com/missive/emoji-mart/pull/297)
- fix: improve accessible page structure [`#296`](https://github.com/missive/emoji-mart/pull/296)
- fix: use tabIndex, not tabindex [`#295`](https://github.com/missive/emoji-mart/pull/295)
- fix: fix search input when value is prepopulated [`#290`](https://github.com/missive/emoji-mart/pull/290)
- fix: fix emoji.id undefined error [`#289`](https://github.com/missive/emoji-mart/pull/289)
- fix: remove unused notFoundString prop [`#288`](https://github.com/missive/emoji-mart/pull/288)
- perf: throttle keyboard input to improve responsiveness [`#287`](https://github.com/missive/emoji-mart/pull/287)
- fix: fix preact compatibility [`#285`](https://github.com/missive/emoji-mart/pull/285)
- fix: improve a11y of emoji list [`#284`](https://github.com/missive/emoji-mart/pull/284)
- fix: makes skin tone picker more accessible [`#283`](https://github.com/missive/emoji-mart/pull/283)
- fix: make categories into accessible nav buttons [`#282`](https://github.com/missive/emoji-mart/pull/282)
- fix: improve search/clear a11y [`#281`](https://github.com/missive/emoji-mart/pull/281)
- fix: add prop-types to dependencies [`#280`](https://github.com/missive/emoji-mart/pull/280)
- feat: add slim builds for modern browsers [`#260`](https://github.com/missive/emoji-mart/pull/260)
- fix: fix babel-runtime not found [`#278`](https://github.com/missive/emoji-mart/pull/278)
- Support case where showPreview is false but showSkinTones is true. Also add prepare script. [`#277`](https://github.com/missive/emoji-mart/pull/277)
- docs: add more explicit dev docs [`#276`](https://github.com/missive/emoji-mart/pull/276)
- fix: allow prop-types to be removed in production [`#258`](https://github.com/missive/emoji-mart/pull/258)
- Fixed bug where selecting the first emoji search result with the ENTER KEY ignores skin tone selection [`#270`](https://github.com/missive/emoji-mart/pull/270)
- fix: forces emoji's not to break line [`#261`](https://github.com/missive/emoji-mart/pull/261)
- fix: fix native emoji on Linux [`#256`](https://github.com/missive/emoji-mart/pull/256)
- fix: improve a11y of emoji list [`#218`](https://github.com/missive/emoji-mart/issues/218)
- fix: makes skin tone picker more accessible [`#220`](https://github.com/missive/emoji-mart/issues/220)
- fix: fix emoji.id undefined error [`#201`](https://github.com/missive/emoji-mart/issues/201)
- fix: fix preact compatibility [`#254`](https://github.com/missive/emoji-mart/issues/254)
- fix: make categories into accessible nav buttons [`#219`](https://github.com/missive/emoji-mart/issues/219)
- fix: improve search/clear a11y [`#221`](https://github.com/missive/emoji-mart/issues/221)
- feat: add slim builds for modern browsers [`#259`](https://github.com/missive/emoji-mart/issues/259)
- fix: fix babel-runtime not found [`#228`](https://github.com/missive/emoji-mart/issues/228)
- docs: add more explicit dev docs [`#227`](https://github.com/missive/emoji-mart/issues/227)
- fix: allow prop-types to be removed in production [`#257`](https://github.com/missive/emoji-mart/issues/257)
- fix: fix native emoji on Linux [`#255`](https://github.com/missive/emoji-mart/issues/255)
- tweak babelrc to use runtime helpers for Object.assign [`c13b730`](https://github.com/missive/emoji-mart/commit/c13b730dbe75c34eb6ee4391715ca4041011dc93)
- fix webkit CSS, fix clear button [`bd17294`](https://github.com/missive/emoji-mart/commit/bd172943d28982d751cfb6b9c7a7c731728bace1)
- fix prettier [`ef71101`](https://github.com/missive/emoji-mart/commit/ef71101cd6bb0ebb7538615a6ccaa1edad62cb9c)

#### [v2.9.2](https://github.com/missive/emoji-mart/compare/v2.9.1...v2.9.2)

> 3 December 2018

- Adds Spritesheets for Custom Emojis [`#251`](https://github.com/missive/emoji-mart/pull/251)
- Add sprite support [`94baec1`](https://github.com/missive/emoji-mart/commit/94baec171dc894e204c805b47d5da2c90a11d827)
- Add `getEmojiDataFromNative` util function to get emoji data from native [`1c7a5d6`](https://github.com/missive/emoji-mart/commit/1c7a5d6ec6b0591408426b1413fc4f7092063c27)
- Add `Get emoji data from Native` story [`f90defb`](https://github.com/missive/emoji-mart/commit/f90defbed702381a808cf282683acb10d43e4492)

#### [v2.9.1](https://github.com/missive/emoji-mart/compare/v2.9.0...v2.9.1)

> 14 November 2018

- Update gh-pages [`08eb6db`](https://github.com/missive/emoji-mart/commit/08eb6db2700e4a38cdbd3b2ae505d876f71c513e)
- Release v2.9.1 [`aaa91c9`](https://github.com/missive/emoji-mart/commit/aaa91c949e2fe42475564dd36053921b84971edf)
- Update gh-pages [`3482a56`](https://github.com/missive/emoji-mart/commit/3482a56d602590fab9a8773ce8cf2165465af6b8)

#### [v2.9.0](https://github.com/missive/emoji-mart/compare/v2.8.1...v2.9.0)

> 13 November 2018

- fix(a11y): ability to tab through different categories [`#226`](https://github.com/missive/emoji-mart/pull/226)
- Add trailing colon to :octocat [`#231`](https://github.com/missive/emoji-mart/pull/231)
- Import compoments directly to avoid components/picker/index.js and have smaller bundle [`#245`](https://github.com/missive/emoji-mart/pull/245)
- Update yarn.lock [`9196a87`](https://github.com/missive/emoji-mart/commit/9196a877697698a46f3e331050c1fd96d939e8b1)
- Get rid of components index [`21b3e92`](https://github.com/missive/emoji-mart/commit/21b3e92bb2122953d79cbabc21d3225ef2262ad4)
- Update nimble-picker.js [`9cad93d`](https://github.com/missive/emoji-mart/commit/9cad93d015051979177d274c75ba9db47ba6e505)

#### [v2.8.1](https://github.com/missive/emoji-mart/compare/v2.8.0...v2.8.1)

> 16 August 2018

- Fixes display of non-52x52 sprite sheets in the preview bar [`#215`](https://github.com/missive/emoji-mart/pull/215)
- Release v2.8.1 [`1c14c86`](https://github.com/missive/emoji-mart/commit/1c14c868b17b5000fae039fa7d60a42ca393227c)
- Fixes display of non-52x52 sheets in the preview bar [`c6b3694`](https://github.com/missive/emoji-mart/commit/c6b36947d341b78555c327f94af718989a553927)

#### [v2.8.0](https://github.com/missive/emoji-mart/compare/v2.7.0...v2.8.0)

> 10 August 2018

- Custom emoji for skin tone selector [`#209`](https://github.com/missive/emoji-mart/pull/209)
- Add sheetColumns and sheetRows props for non-square sprite sheets [`#212`](https://github.com/missive/emoji-mart/pull/212)
- fix typo in README.md [`#213`](https://github.com/missive/emoji-mart/pull/213)
- Update gh-pages [`5e15356`](https://github.com/missive/emoji-mart/commit/5e15356379e0942e47a35cd4f9780d5a6a8fbf23)
- :lipstick: [`94e7b2d`](https://github.com/missive/emoji-mart/commit/94e7b2d8784258b0f530c8d46871946016a948f3)
- Rename “skinIcon” => “skinEmoji” [`2c060c5`](https://github.com/missive/emoji-mart/commit/2c060c56bc83276fbe68e7e8fcda9ddc79851fea)

#### [v2.7.0](https://github.com/missive/emoji-mart/compare/v2.6.1...v2.7.0)

> 31 July 2018

- Customizable Category Icons [`#208`](https://github.com/missive/emoji-mart/pull/208)
- Not Found Component for emoji search [`#206`](https://github.com/missive/emoji-mart/pull/206)
- Adding search icon in search input field [`#205`](https://github.com/missive/emoji-mart/pull/205)
- Added font stack to support native emojis in IE11/Edge [`#203`](https://github.com/missive/emoji-mart/pull/203)
- Call fallback when emoji name isn’t recognized [Fix #199] [`#199`](https://github.com/missive/emoji-mart/issues/199)
- Update gh-pages [`34ba02f`](https://github.com/missive/emoji-mart/commit/34ba02fc4b9e43734304a47c4868a2ff88cba1b2)
- Add notFoundEmoji props to Picker [`4bb41b9`](https://github.com/missive/emoji-mart/commit/4bb41b9796fdd8a36c9ac51aefb8007eb5d1dbc4)
- Don’t apply `emoji-mart-no-results` class when using custom notFound component [`3dc3e2f`](https://github.com/missive/emoji-mart/commit/3dc3e2fd954fbf7da4ea9825a103bc42661856e9)

#### [v2.6.1](https://github.com/missive/emoji-mart/compare/v2.6.0...v2.6.1)

> 11 May 2018

- Add missing onSelect to shared props [`#183`](https://github.com/missive/emoji-mart/pull/183)
- Correct NimbleEmojiIndex reexport [`#187`](https://github.com/missive/emoji-mart/pull/187)
- Fix crash in NimbleEmojiIndex when using custom emojis [`#185`](https://github.com/missive/emoji-mart/pull/185)
- Update gh-pages [`9cda3c9`](https://github.com/missive/emoji-mart/commit/9cda3c974c25012578d4cc9f7ac03ca4eff5dd65)
- Update README [`4715fe8`](https://github.com/missive/emoji-mart/commit/4715fe8f487a51796127626db23b3708a58b2539)
- Release v2.6.1 [`b1c499f`](https://github.com/missive/emoji-mart/commit/b1c499fc8d7fbcd89f5bd23015df3d10dcc440e3)

#### [v2.6.0](https://github.com/missive/emoji-mart/compare/v2.5.1...v2.6.0)

> 30 April 2018

- Add parent components and data property for components that reference data.js Issue#86 [`#178`](https://github.com/missive/emoji-mart/pull/178)
- Update gh-pages [`5766266`](https://github.com/missive/emoji-mart/commit/57662665d3f7e1fbc4cc961525316219f79ba6ff)
- Add data property to any components that import data.js, and use that under the hood [`892096e`](https://github.com/missive/emoji-mart/commit/892096ea27e8a1f0ba7f87f4eba3df44f6e953f4)
- Restructure data and components [`2e97b1f`](https://github.com/missive/emoji-mart/commit/2e97b1faa671c017fc74dd1df8da1468f84d5cb7)

#### [v2.5.1](https://github.com/missive/emoji-mart/compare/v2.5.0...v2.5.1)

> 27 March 2018

- Select first emoji in list with `enter` [`#175`](https://github.com/missive/emoji-mart/pull/175)
- Clearing custom emojis from index and pool when necessary [`#172`](https://github.com/missive/emoji-mart/pull/172)
- doc: add css in readme [`#174`](https://github.com/missive/emoji-mart/pull/174)
- :lipstick: Add prettier.config.js [`c113dc5`](https://github.com/missive/emoji-mart/commit/c113dc5e3b934e0b867fdd568d7137d5f041cf46)
- Update gh-pages [`6d557a5`](https://github.com/missive/emoji-mart/commit/6d557a5beed8f40000d89a5473c85b6e78125826)
- Add keyboard selection with enter [`0765bf5`](https://github.com/missive/emoji-mart/commit/0765bf56f751457e36765bed0dbb44a3d4c721ed)

#### [v2.5.0](https://github.com/missive/emoji-mart/compare/v2.4.2...v2.5.0)

> 2 March 2018

- Custom Emojis as a changing prop [`#167`](https://github.com/missive/emoji-mart/pull/167)
- fix Categories sort compareFunction return to -1 from 0 in Picker component [`#164`](https://github.com/missive/emoji-mart/pull/164)
- Add `contentEditable` guide to README [Close #169] [`#169`](https://github.com/missive/emoji-mart/issues/169)
- Add `onSkinChange` prop to Picker [Close #165] [`#165`](https://github.com/missive/emoji-mart/issues/165)
- Set RECENT_CATEGORY, CUSTOM_CATEGORY and SEARCH_CATEGORY on Picker instances [Fix #166] [`#166`](https://github.com/missive/emoji-mart/issues/166)
- Update gh-pages [`a7cd5e5`](https://github.com/missive/emoji-mart/commit/a7cd5e5d9637f04757af0fb910d80456b88ab578)
- Add `showSkinTones` prop to Picker [Ref #165] [`c010035`](https://github.com/missive/emoji-mart/commit/c010035015524cf09d75e26b7cffd544c663d1fc)
- Add `defaultSkin` prop to Picker and allow forcing skin tone with `skin` prop [Ref #165] [`af2fdc7`](https://github.com/missive/emoji-mart/commit/af2fdc71a1c725622e6cdc24bc4e9ef59f627407)

#### [v2.4.2](https://github.com/missive/emoji-mart/compare/v2.4.1...v2.4.2)

> 24 January 2018

- remove unused name [`#159`](https://github.com/missive/emoji-mart/pull/159)
- Emoji fallback shouldn't apply styling #157 [`#158`](https://github.com/missive/emoji-mart/pull/158)
- Release v2.4.2 [`b1ba2b7`](https://github.com/missive/emoji-mart/commit/b1ba2b777a03fa60c7f67e2d9ee57f3d93793ff9)
- Don't render fallback inside an emoji `<span>` [`4008363`](https://github.com/missive/emoji-mart/commit/4008363e73b573234adbbe72e65d3773e9675ebc)
- Remove Emoji fallback defaultProp [`238b2d2`](https://github.com/missive/emoji-mart/commit/238b2d2ff245eb62bf6300642ce6d9648d3cf627)

#### [v2.4.1](https://github.com/missive/emoji-mart/compare/v2.4.0...v2.4.1)

> 9 January 2018

- Fix search with custom data and filter [`#153`](https://github.com/missive/emoji-mart/pull/153)
- Bug Fix: Ensure category ids are not dropped after emojisToShowFilter call [`#154`](https://github.com/missive/emoji-mart/pull/154)
- add required props in <Emoji /> example [`#155`](https://github.com/missive/emoji-mart/pull/155)
- Support providing a fallback to unsupported emojis [Fix #157] [`#157`](https://github.com/missive/emoji-mart/issues/157)
- Update gh-pages [`e698358`](https://github.com/missive/emoji-mart/commit/e698358ea732cd2b792f33b273e33894791ead9c)
- Add `html` props to Emoji component [Ref #79] [`6d095a0`](https://github.com/missive/emoji-mart/commit/6d095a072c4a7e80c4645ec2550297d5a15cd542)
- :lipstick: [`68a4711`](https://github.com/missive/emoji-mart/commit/68a4711658fb97501cfa730703be8b0c4f432c7d)

#### [v2.4.0](https://github.com/missive/emoji-mart/compare/v2.3.0...v2.4.0)

> 15 December 2017

- Fix include / exclude [Fix #149] [`#149`](https://github.com/missive/emoji-mart/issues/149)
- Update gh-pages [`373c009`](https://github.com/missive/emoji-mart/commit/373c0090659cbfee644ce9901596565d9552e265)
- Revert "Merge pull request #99 from chadoh/countries-search" [`c70568c`](https://github.com/missive/emoji-mart/commit/c70568c3927ca53e95bce72121852bf38a3e070b)
- Use 256-color indexed sheets by default [`8f63c38`](https://github.com/missive/emoji-mart/commit/8f63c3830814e257e2931fa4d8a6fc0e240753ff)

#### [v2.3.0](https://github.com/missive/emoji-mart/compare/v2.2.1...v2.3.0)

> 8 December 2017

- Update gh-pages [`e3ddfa5`](https://github.com/missive/emoji-mart/commit/e3ddfa584b27ab499b5598709cea6bf8d5f95ce5)
- Fix getting category names from i18n [`fdf3c2d`](https://github.com/missive/emoji-mart/commit/fdf3c2d3a3575845f6aa1cf3be1037c402dae4ed)
- Update category names [`66f9776`](https://github.com/missive/emoji-mart/commit/66f97765839686a95b82bbaff2b2dbb1daef0b5e)

#### [v2.2.1](https://github.com/missive/emoji-mart/compare/v2.2.0...v2.2.1)

> 10 November 2017

- Handle invalid emoji name in `Emoji` component [Fix #143] [`#143`](https://github.com/missive/emoji-mart/issues/143)
- Add /docs [`772b9ab`](https://github.com/missive/emoji-mart/commit/772b9ab534bc7288ec3f3aebfe61f388a7fea2d7)
- Fix CSS in /docs [`deeba72`](https://github.com/missive/emoji-mart/commit/deeba72831e18b5be78568903ba51ac8dd5918e6)
- Reduce svgs/index.js size 10% [`cecb92b`](https://github.com/missive/emoji-mart/commit/cecb92bb9f0b755373887dd018e2d4e83e610b35)

#### [v2.2.0](https://github.com/missive/emoji-mart/compare/v2.1.2...v2.2.0)

> 9 November 2017

- Fix CSS for IE10 [Close #135] [`#135`](https://github.com/missive/emoji-mart/issues/135)
- Provide more data to `emojisToShowFilter` in search [Fix #141] [`#141`](https://github.com/missive/emoji-mart/issues/141)
- Retinafy images [`724bed6`](https://github.com/missive/emoji-mart/commit/724bed6e4e672ce8f50f7748c62f0cfbeae76eef)
- Update README [`d4c86bc`](https://github.com/missive/emoji-mart/commit/d4c86bc6e17820bcefa1fee82e45c2f978136dd4)
- Release v2.2.0 [`c4c2584`](https://github.com/missive/emoji-mart/commit/c4c258466a2ab85d4f735902406056fbc3efdb5c)

#### [v2.1.2](https://github.com/missive/emoji-mart/compare/v2.1.1...v2.1.2)

> 8 November 2017

- Feature filter invalid emojis [`#133`](https://github.com/missive/emoji-mart/pull/133)
- Allow passing down a `recent` prop instead of localStorage [`#132`](https://github.com/missive/emoji-mart/pull/132)
- Early return `measureScrollbar` when document isn’t defined [Fix #136] [`#136`](https://github.com/missive/emoji-mart/issues/136)
- Fix #129 - Passing down a `recent` prop instead of localStorage [`#129`](https://github.com/missive/emoji-mart/issues/129)
- Prettier :lipstick: [`3021758`](https://github.com/missive/emoji-mart/commit/30217581153077ac0c760d85bf93ff1ade78ff06)
- Handle using custom storage instead of localStorage [`9cd6494`](https://github.com/missive/emoji-mart/commit/9cd6494c394add8283cabc03dd7823e3a39041e7)
- :lipstick: [`b24b0cc`](https://github.com/missive/emoji-mart/commit/b24b0ccee563f91d292ddfd0016ef02916c2413e)

#### [v2.1.1](https://github.com/missive/emoji-mart/compare/v2.1.0...v2.1.1)

> 6 October 2017

- Intersect search results [Fix #131] [`#131`](https://github.com/missive/emoji-mart/issues/131)
- Add test for thinking_face/woman-facepalming [`9b6ddf0`](https://github.com/missive/emoji-mart/commit/9b6ddf0c9cd78d7a235950d0f7074d82d1015450)
- Release v2.1.1 [`5f2ffcc`](https://github.com/missive/emoji-mart/commit/5f2ffcc0be0ec46dc413d3e9739338174ca10b4a)
- Fix spec syntax error [`b0e1d44`](https://github.com/missive/emoji-mart/commit/b0e1d44d6eb3ce3c2ca43dc483949c03b3c8f0e6)

#### [v2.1.0](https://github.com/missive/emoji-mart/compare/v2.0.1...v2.1.0)

> 6 October 2017

- Fix tests [`#130`](https://github.com/missive/emoji-mart/pull/130)
- Build as ES module as well as CommonJS [`#120`](https://github.com/missive/emoji-mart/pull/120)
- Remove function binds in render wherever possible, use PureComponent [`#125`](https://github.com/missive/emoji-mart/pull/125)
- Fix headless search with custom emojis [Fix #118] [`#118`](https://github.com/missive/emoji-mart/issues/118)
- Fix include sorting [Fix #116] [`#116`](https://github.com/missive/emoji-mart/issues/116)
- Set `background-size: cover` for custom emojis [Fix #117] [`#117`](https://github.com/missive/emoji-mart/issues/117)
- Fix TypeError on emoji click when picker has been unmounted [Fix #126] [`#126`](https://github.com/missive/emoji-mart/issues/126)
- Revert Emoji back to a functional component [`22d1a03`](https://github.com/missive/emoji-mart/commit/22d1a0375dd9f3814db6623461785784858b9c86)
- Signify custom emoji elements with class [Ref #117] [`1a2d400`](https://github.com/missive/emoji-mart/commit/1a2d400362f903a9eb8d2a960fc8ee370a766cda)
- Exclude flag-un from data [`88cde66`](https://github.com/missive/emoji-mart/commit/88cde669e63dcdb6e7a86bcdd0a44f9f0836c4b4)

#### [v2.0.1](https://github.com/missive/emoji-mart/compare/v2.0.0...v2.0.1)

> 29 September 2017

- Remove function binds in render wherever possible, use PureComponent [`fdb88da`](https://github.com/missive/emoji-mart/commit/fdb88daa31f954b669f08462fa7cbce5c7d34c58)
- Use SVGs inline [`81f39b1`](https://github.com/missive/emoji-mart/commit/81f39b138a65ee9e0aa6bdd6d6f8ce0e5f413265)
- Move data in src [`e8dc29b`](https://github.com/missive/emoji-mart/commit/e8dc29bfaa868687a61e0d55d59667b9e63cd6e6)

### [v2.0.0](https://github.com/missive/emoji-mart/compare/v1.0.1...v2.0.0)

> 28 September 2017

- Add a storybook [`#124`](https://github.com/missive/emoji-mart/pull/124)
- Upgrade to React 16 [`#123`](https://github.com/missive/emoji-mart/pull/123)
- Package size reduced from 87.35 KB to 79.43 KB [`#113`](https://github.com/missive/emoji-mart/pull/113)
- Use will-change:transform for smoother mobile scrolling [`#119`](https://github.com/missive/emoji-mart/pull/119)
- Compress data [`#111`](https://github.com/missive/emoji-mart/pull/111)
- Babel fixes [`#110`](https://github.com/missive/emoji-mart/pull/110)
- Feature/replace webpack tasks on babel [`#108`](https://github.com/missive/emoji-mart/pull/108)
- Reduce npm package size [`#104`](https://github.com/missive/emoji-mart/pull/104)
- Add package size profiling tools [`#103`](https://github.com/missive/emoji-mart/pull/103)
- Search country flags using country names [`#99`](https://github.com/missive/emoji-mart/pull/99)
- Add showPreview props to Picker [Fix #42] [`#42`](https://github.com/missive/emoji-mart/issues/42)
- Update emoji-datasource version in README [Fix #115] [`#115`](https://github.com/missive/emoji-mart/issues/115)
- Add react-storybook [`a69125c`](https://github.com/missive/emoji-mart/commit/a69125ce4014d41c4a56bb34f2f057cf37637d72)
- Size reduced from 87.35 KB to 79.43 KB [`4dc05ef`](https://github.com/missive/emoji-mart/commit/4dc05ef8da8764c58fcdbf5eed98f886cbf38062)
- Get rid of /example [`d6e9a6a`](https://github.com/missive/emoji-mart/commit/d6e9a6afae6e45b735686ee290ed60d27c3c5cc8)

#### [v1.0.1](https://github.com/missive/emoji-mart/compare/v1.0.0...v1.0.1)

> 27 June 2017

- Improve support for Internet Explorer [`#92`](https://github.com/missive/emoji-mart/pull/92)
- Fix shift when scrollbar is rendered [`#93`](https://github.com/missive/emoji-mart/pull/93)
- Text representation of emoji is different from emoticon [`#88`](https://github.com/missive/emoji-mart/pull/88)
- Do not store recently used if 'recent' category is excluded. [`#83`](https://github.com/missive/emoji-mart/pull/83)
- Fix search with include/exclude [Fix #89] [`#89`](https://github.com/missive/emoji-mart/issues/89)
- Make custom emojis work on example page [Ref #87] [`f3f60f5`](https://github.com/missive/emoji-mart/commit/f3f60f58b3b3ac95f27cf22ad6edb9586c5d923f)
- Include scrollbar width in total picker width [`385408b`](https://github.com/missive/emoji-mart/commit/385408b51c14f9632bf765a4337cbc104e4958ea)
- Use Babel’s transform-runtime plugin [`1b9b898`](https://github.com/missive/emoji-mart/commit/1b9b8983bbae771daf4f9d6b7453fd614eab665f)

### [v1.0.0](https://github.com/missive/emoji-mart/compare/v0.5.0...v1.0.0)

> 27 May 2017

- Add support for custom emojis [`#85`](https://github.com/missive/emoji-mart/pull/85)
- Update to latest emoji-datasource [`#78`](https://github.com/missive/emoji-mart/pull/78)
- Update react and remove react-addons-test-utils [`#80`](https://github.com/missive/emoji-mart/pull/80)
- Allow preview emoji to be hidden. [`#84`](https://github.com/missive/emoji-mart/pull/84)
- Update yarn.lock [`#82`](https://github.com/missive/emoji-mart/pull/82)
- Installation instructions & stylesheet corrections [`#73`](https://github.com/missive/emoji-mart/pull/73)
- update components from React.PropTypes to PropTypes package [`#74`](https://github.com/missive/emoji-mart/pull/74)
- give max height to svg for IE support [`#77`](https://github.com/missive/emoji-mart/pull/77)
- Add default frequently used defaults (closes #63) [`#64`](https://github.com/missive/emoji-mart/pull/64)
- Do not include search input in the scroll container [Close #58] [`#58`](https://github.com/missive/emoji-mart/issues/58)
- Add default frequently used defaults (closes #63) [`#63`](https://github.com/missive/emoji-mart/issues/63)
- Functional Emoji component [`d2e37ca`](https://github.com/missive/emoji-mart/commit/d2e37cad6d1c7539d9ec4d9e4f2d40aec92e98f8)
- Use svg-jsx for anchors [`1d57c21`](https://github.com/missive/emoji-mart/commit/1d57c216f5973d106e9990a35ceae6513ff562a5)
- update components from React.PropTypes to PropTypes package to avoid [`ed5a6f1`](https://github.com/missive/emoji-mart/commit/ed5a6f1777d3dc80f6dda5251652f674d1aadb24)

#### [v0.5.0](https://github.com/missive/emoji-mart/compare/v0.4.4...v0.5.0)

> 18 April 2017

- add prop to autofocus search input [`#54`](https://github.com/missive/emoji-mart/pull/54)
- Added `include` and `exclude` props to filter emoji categories [`#53`](https://github.com/missive/emoji-mart/pull/53)
- Remove “No emoji found” hover [Close #59] [`#59`](https://github.com/missive/emoji-mart/issues/59)
- Add “No emoji found” to i18n [Close #52] [`#52`](https://github.com/missive/emoji-mart/issues/52)
- Support including/excluding the recent category [`c1bd9ea`](https://github.com/missive/emoji-mart/commit/c1bd9ea52ca96cd1009b50a62593b1f5b4b0015b)
- Update “No Emoji Found” layout [`f07c0c0`](https://github.com/missive/emoji-mart/commit/f07c0c063860ecf54ad4878c5ba4420ef512063f)
- :lipstick: [`4926b7b`](https://github.com/missive/emoji-mart/commit/4926b7bd43e86737edfcabb59407cbed437830d9)

#### [v0.4.4](https://github.com/missive/emoji-mart/compare/v0.4.3...v0.4.4)

> 17 March 2017

- Include unified in sanitized data [Close #51] [`#51`](https://github.com/missive/emoji-mart/issues/51)
- Release v0.4.4 [`9a713ad`](https://github.com/missive/emoji-mart/commit/9a713ad88543f6f43b23037f617dec6b205384b4)

#### [v0.4.3](https://github.com/missive/emoji-mart/compare/v0.4.2...v0.4.3)

> 10 March 2017

- Data file size reduction: strip quotes around keys [`#49`](https://github.com/missive/emoji-mart/pull/49)
- Delete empty arrays from data file [`2de8310`](https://github.com/missive/emoji-mart/commit/2de83100a02b8374686ee6a318d882e0e96e820a)
- Don’t include keywords in data file [`dbf2207`](https://github.com/missive/emoji-mart/commit/dbf22073c8d25a2c797eab7b2e9cd58147229f1a)
- Strip quotes around keys [`0bfd3b3`](https://github.com/missive/emoji-mart/commit/0bfd3b3e52ee60d7e2c303544990aa4ef52a5f37)

#### [v0.4.2](https://github.com/missive/emoji-mart/compare/v0.4.1...v0.4.2)

> 17 February 2017

- Use variations at runtime instead of overriding data [`f5ae64d`](https://github.com/missive/emoji-mart/commit/f5ae64d07ce4bfd341ddcc390d02832792cd87bd)
- Release v0.4.2 [`87ab03e`](https://github.com/missive/emoji-mart/commit/87ab03e6bdbf74911d7b2be22031738466c70a54)

#### [v0.4.1](https://github.com/missive/emoji-mart/compare/v0.4.0...v0.4.1)

> 17 February 2017

- Prefer first variation over default unified value [`489641b`](https://github.com/missive/emoji-mart/commit/489641bda6ec6353df9b713094ce570a160eb203)
- Release v0.4.1 [`ff0cc12`](https://github.com/missive/emoji-mart/commit/ff0cc12fbc386f571260475fc40bdee309916017)
- Fix `watch` script not bundling example [`44d401a`](https://github.com/missive/emoji-mart/commit/44d401ae489009b48df3594c22655b175fc93a42)

#### [v0.4.0](https://github.com/missive/emoji-mart/compare/v0.3.7...v0.4.0)

> 17 February 2017

- Allow picker to display emoji natively [`#40`](https://github.com/missive/emoji-mart/pull/40)
- Add karma/jasmine + tests for emoji-index and picker [`#44`](https://github.com/missive/emoji-mart/pull/44)
- allow style overrides from user [`#45`](https://github.com/missive/emoji-mart/pull/45)
- Fix categories on IE11 [`#46`](https://github.com/missive/emoji-mart/pull/46)
- Add emojisToShow filter [`#43`](https://github.com/missive/emoji-mart/pull/43)
- Preserve height and width on svgs [`#41`](https://github.com/missive/emoji-mart/pull/41)
- Category: export from index.js [`#39`](https://github.com/missive/emoji-mart/pull/39)
- Use yarn [`00fdf61`](https://github.com/missive/emoji-mart/commit/00fdf6137ab496baef234333ad48d47b4c3b34fd)
- add emojisToShow filter [`1a6e0e0`](https://github.com/missive/emoji-mart/commit/1a6e0e0fd31a8b1fdfc74ec8df09f0ef0997185d)
- Uncomment PR #43 specs [`5c27f17`](https://github.com/missive/emoji-mart/commit/5c27f17154376ab2e4d13b2671ee391a489fe4f6)

#### [v0.3.7](https://github.com/missive/emoji-mart/compare/v0.3.6...v0.3.7)

> 18 January 2017

- Add emoji prop change check to Emoji component [`#35`](https://github.com/missive/emoji-mart/pull/35)
- Fix issue with operator in skin tone logic [`#29`](https://github.com/missive/emoji-mart/pull/29)
- Release v0.3.7 [`a02cca7`](https://github.com/missive/emoji-mart/commit/a02cca753581d33284f7432d41ea291057fa6da5)

#### [v0.3.6](https://github.com/missive/emoji-mart/compare/v0.3.5...v0.3.6)

> 16 January 2017

- wrap localStorage access in try-catch [`#34`](https://github.com/missive/emoji-mart/pull/34)
- Release v0.3.6 [`7ffcecf`](https://github.com/missive/emoji-mart/commit/7ffcecf68eb7ae2d55d6165299d5c7369c662237)
- Fix issue with operator in skin tone logic [`0db181e`](https://github.com/missive/emoji-mart/commit/0db181e301a1edcb0ef1ff699f9f23e424c69bab)

#### [v0.3.5](https://github.com/missive/emoji-mart/compare/v0.3.4...v0.3.5)

> 8 December 2016

- Allow custom namespace for store [`#27`](https://github.com/missive/emoji-mart/pull/27)
- Allow passing children to Emoji component [`#28`](https://github.com/missive/emoji-mart/pull/28)
- :lipstick: [`672a6a4`](https://github.com/missive/emoji-mart/commit/672a6a4dfc7e90ae79cb45dd695a18eeef10c83a)
- Release v0.3.5 [`1482050`](https://github.com/missive/emoji-mart/commit/1482050298bbe57013835dba94457185dbf49e33)
- Use children passed through props [`771b1e4`](https://github.com/missive/emoji-mart/commit/771b1e48f38b25bca6c37741f36b3d96e3a86370)

#### [v0.3.4](https://github.com/missive/emoji-mart/compare/v0.3.3...v0.3.4)

> 1 December 2016

- Allow a custom backgroundImageFn to be passed in [`#26`](https://github.com/missive/emoji-mart/pull/26)
- Add backgroundImageFn to allow local image sheets [`a4be90a`](https://github.com/missive/emoji-mart/commit/a4be90aa6e6d56f4e7d4eacc40aed4429a217ed2)
- Use dynamic version of emoji-datasource for the default sheet URL [`462ba0c`](https://github.com/missive/emoji-mart/commit/462ba0cd26b5de41392e879c45b2fc54b32b7d25)
- Don’t check for backgroundImageFn change in Category#shouldComponentUpdate [`0d39e10`](https://github.com/missive/emoji-mart/commit/0d39e10a71b4d30f2c7553e4dc9027d1ced640b9)

#### [v0.3.3](https://github.com/missive/emoji-mart/compare/v0.3.2...v0.3.3)

> 17 November 2016

- Normalize line-height for all elements [Fix #24] [`#24`](https://github.com/missive/emoji-mart/issues/24)
- Release v0.3.3 [`2931f55`](https://github.com/missive/emoji-mart/commit/2931f55e9382f0bfe20bbc710b45d4347402968c)

#### [v0.3.2](https://github.com/missive/emoji-mart/compare/v0.3.1...v0.3.2)

> 1 November 2016

- Isolate .emoji-mart-anchors from page line-height [`#22`](https://github.com/missive/emoji-mart/pull/22)
- Update example [`4076bb4`](https://github.com/missive/emoji-mart/commit/4076bb40905263f10cdf2a7342afd1569296ee40)
- Add `native` prop to Emoji [`dad72bc`](https://github.com/missive/emoji-mart/commit/dad72bc0fb823e2d0f8b8d2eabc5880d6695f48c)
- Support :colons: syntax [`c460474`](https://github.com/missive/emoji-mart/commit/c4604741d980dc1406372b9d1e9ab88f0525b019)

#### [v0.3.1](https://github.com/missive/emoji-mart/compare/v0.3.0...v0.3.1)

> 27 October 2016

- Show only vertical scroll [`#21`](https://github.com/missive/emoji-mart/pull/21)
- Add i18n prop to Picker [Close #20] [`#20`](https://github.com/missive/emoji-mart/issues/20)
- Add sheetSize prop to Picker & Emoji [Close #18] [`#18`](https://github.com/missive/emoji-mart/issues/18)
- :lipstick: [`1dfa582`](https://github.com/missive/emoji-mart/commit/1dfa58239f9b8d245dccf6f0661e090447005015)
- Set Emoji.propTypes.skin as an enum [`afe8825`](https://github.com/missive/emoji-mart/commit/afe882560eb1f310e032815e3229b20c915e9623)
- Set Emoji.propTypes.set as an enum [`ecc0862`](https://github.com/missive/emoji-mart/commit/ecc086260a7ddc33f4252173abb41472730c2d2c)

#### [v0.3.0](https://github.com/missive/emoji-mart/compare/v0.2.10...v0.3.0)

> 19 October 2016

- Remove “sheetURL” props & add “set” props [`4f2b204`](https://github.com/missive/emoji-mart/commit/4f2b204c0e225daa1f88a2599b8c7eec1dce3d9a)
- Release v0.3.0 [`f6348a8`](https://github.com/missive/emoji-mart/commit/f6348a8196e7353a42d3d5bbf28622f98ab10c92)

#### [v0.2.10](https://github.com/missive/emoji-mart/compare/v0.2.9...v0.2.10)

> 18 October 2016

- Use hasOwnProperty to detect if emoji exists [`35a9921`](https://github.com/missive/emoji-mart/commit/35a992118ab62812d71db741192cbeeecf59df31)
- Release v0.2.10 [`1b83241`](https://github.com/missive/emoji-mart/commit/1b832414c5ba1956a5dd2031d1b2d395abe042df)

#### [v0.2.9](https://github.com/missive/emoji-mart/compare/v0.2.8...v0.2.9)

> 14 October 2016

- Release v0.2.9 [`e429147`](https://github.com/missive/emoji-mart/commit/e429147d1fe9d1c49bfeccc24e678e8b1c892464)
- Fix “Recent” category showing up when clicking an emoji for the first time while searching [`dc93357`](https://github.com/missive/emoji-mart/commit/dc933571374b5cf01157699c771f2f770ea45180)
- Also split search terms at “-” & “_” [`996c46c`](https://github.com/missive/emoji-mart/commit/996c46cd9cbb19b0737b0d0288dcf6956acbe84d)

#### [v0.2.8](https://github.com/missive/emoji-mart/compare/v0.2.7...v0.2.8)

> 13 October 2016

- Support all short_names when getting emoji data [Fix #15] [`#15`](https://github.com/missive/emoji-mart/issues/15)
- Release v0.2.8 [`0076173`](https://github.com/missive/emoji-mart/commit/00761734d83d815ba3976058867c54e092ba5cb7)

#### [v0.2.7](https://github.com/missive/emoji-mart/compare/v0.2.5...v0.2.7)

> 13 October 2016

- Handle unknown emojis [Fix #14] [`#14`](https://github.com/missive/emoji-mart/issues/14)
- Release v0.2.7 [`00eea58`](https://github.com/missive/emoji-mart/commit/00eea587600eca1d7754c50c04d55de428916080)

#### [v0.2.5](https://github.com/missive/emoji-mart/compare/v0.2.4...v0.2.5)

> 4 October 2016

- Add support for server-side rendering [Fix #7] [`#7`](https://github.com/missive/emoji-mart/issues/7)
- :lipstick: [`903395e`](https://github.com/missive/emoji-mart/commit/903395e31f3b429321e859b378252c4f1423ea54)
- Release v0.2.4 [`ac4feba`](https://github.com/missive/emoji-mart/commit/ac4feba228c18199ecf6a6a960223d0221668e1c)

#### [v0.2.4](https://github.com/missive/emoji-mart/compare/v0.2.3...v0.2.4)

> 30 September 2016

- Replace npmcdn.com with unpkg.com [`#12`](https://github.com/missive/emoji-mart/pull/12)
- Update webpack React externals [Fix #11, Fix #8] [`#11`](https://github.com/missive/emoji-mart/issues/11) [`#8`](https://github.com/missive/emoji-mart/issues/8)
- Release v0.2.4 [`29063f2`](https://github.com/missive/emoji-mart/commit/29063f2f646e7aa9b4970110a819123e1c96c125)

#### [v0.2.3](https://github.com/missive/emoji-mart/compare/v0.2.2...v0.2.3)

> 29 July 2016

- Add GH Star button to demo page [`af3b792`](https://github.com/missive/emoji-mart/commit/af3b7928b376a38aa81bb9660ea6831432749903)
- Update README [`b25b25b`](https://github.com/missive/emoji-mart/commit/b25b25b5ebe11f5908c4960892c9cf24f5d2ccee)
- Release v0.2.3 [`3303566`](https://github.com/missive/emoji-mart/commit/33035669b6157b739b7f01fc8ff1600d631956ed)

#### [v0.2.2](https://github.com/missive/emoji-mart/compare/v0.2.1...v0.2.2)

> 29 July 2016

- Update demo page [`df0c920`](https://github.com/missive/emoji-mart/commit/df0c920f6695faee43ce66a633eed98689ea03bd)
- Build example in `example/bundle.js` [`ecf3784`](https://github.com/missive/emoji-mart/commit/ecf3784d32b9c5d6e95537f82ff7934cdbb8e038)
- Update README [`f01ad53`](https://github.com/missive/emoji-mart/commit/f01ad53b6f1e4585c2beddaa7a3f308dc33e2ce7)

#### [v0.2.1](https://github.com/missive/emoji-mart/compare/v0.2.0...v0.2.1)

> 28 July 2016

- Update README [`9c7e461`](https://github.com/missive/emoji-mart/commit/9c7e461e21b46f13540fd80382a67fe60f1e5008)
- BSD Simplified license [`3dd27d3`](https://github.com/missive/emoji-mart/commit/3dd27d3a1359ff7008012114d3045646f665d0fd)
- Release v0.2.1 [`16a4256`](https://github.com/missive/emoji-mart/commit/16a42565cc898055c798b5d38a7040b9f476e938)

#### [v0.2.0](https://github.com/missive/emoji-mart/compare/v0.1.5...v0.2.0)

> 27 July 2016

- Ignore data & dist folders and add prepublish npm script [`3f04c9c`](https://github.com/missive/emoji-mart/commit/3f04c9cafa2d1029cb277effd5eaa7a9fef88492)
- 🏬 Emoji Mart™ [`9648c7d`](https://github.com/missive/emoji-mart/commit/9648c7d8e20f10b407a8786e77b5e73d07314815)
- Release v0.2.0 [`d10f914`](https://github.com/missive/emoji-mart/commit/d10f914f17e2665616bb7a19c31b9f9fc4761b87)

#### [v0.1.5](https://github.com/missive/emoji-mart/compare/v0.1.4...v0.1.5)

> 26 July 2016

- Sort search results by score [Close #1] [`#1`](https://github.com/missive/emoji-mart/issues/1)
- Release v0.1.5 [`760d140`](https://github.com/missive/emoji-mart/commit/760d140410d730b45916d7af85b0002ddcc08980)
- Update emojis search string [`9feee08`](https://github.com/missive/emoji-mart/commit/9feee08e069b11ea93025fdb2003736d7a7138f9)
- Export frequently util [`2b734d8`](https://github.com/missive/emoji-mart/commit/2b734d8ef6075017746bffeb71e2151013898e6a)

#### [v0.1.4](https://github.com/missive/emoji-mart/compare/v0.1.3...v0.1.4)

> 22 July 2016

- Release v0.1.4 [`b702397`](https://github.com/missive/emoji-mart/commit/b7023971ad714a9c19d18e3758e36241aeafb101)
- Use custom search index instead of lunr [`be1e670`](https://github.com/missive/emoji-mart/commit/be1e6705c3bf18f254768eaf541134b882618d15)
- Support searching for multiple (2) terms [`5721f5f`](https://github.com/missive/emoji-mart/commit/5721f5f6949a8a72339de0b26be5a9cccc553fc2)

#### [v0.1.3](https://github.com/missive/emoji-mart/compare/v0.1.2...v0.1.3)

> 20 July 2016

- Release v0.1.3 [`aed099c`](https://github.com/missive/emoji-mart/commit/aed099cd1c3efa0192ef74ae49b9e3caf8d33c50)
- Move some reusable logic into utils [`a51626a`](https://github.com/missive/emoji-mart/commit/a51626ae79383bd21df3e912ee46afd3aa468a1d)
- Fix circular dependencies [`0ebd5c4`](https://github.com/missive/emoji-mart/commit/0ebd5c4a5e8bb8dfa76b79a62b805a1ed53bfc2a)

#### [v0.1.2](https://github.com/missive/emoji-mart/compare/v0.1.1...v0.1.2)

> 15 July 2016

- Release v0.1.2 [`1615fc1`](https://github.com/missive/emoji-mart/commit/1615fc1f34f015e3630319db1dca17deefd57c4a)
- Only render first 3 categories on first render [`9eb8f0b`](https://github.com/missive/emoji-mart/commit/9eb8f0b6ac3ecdd814dc55470fbaf44e801a395d)
- Make picker’s title and emoji customizable [`b0893c3`](https://github.com/missive/emoji-mart/commit/b0893c39be88fbc9479cddf18e8662d842d95249)

#### [v0.1.1](https://github.com/missive/emoji-mart/compare/v0.1.0...v0.1.1)

> 12 July 2016

- Do not generate .map files [`820bb3d`](https://github.com/missive/emoji-mart/commit/820bb3d966ffe0a1bc0de83b78769bae55f232c5)
- Release v0.1.1 [`ce3ab53`](https://github.com/missive/emoji-mart/commit/ce3ab5340047076a9dd74f362d547e29c4381f1b)
- Fix external React lib name [`d9f5cd3`](https://github.com/missive/emoji-mart/commit/d9f5cd3101b64d349d5bed69435fe724ff789ec1)

#### v0.1.0

> 11 July 2016

- Release v0.1.0 [`17a86d5`](https://github.com/missive/emoji-mart/commit/17a86d52688d2b6fda9eec051084483e64d2bc4d)
- Do not ignore data and dist folders [`69e9dfe`](https://github.com/missive/emoji-mart/commit/69e9dfea0026c7ca05231af94273d74b9b5d63d3)
- Initial commit [`e108b00`](https://github.com/missive/emoji-mart/commit/e108b00768b009540b18738349b049800f58f296)
