"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const launchdarkly_js_client_sdk_1 = require("launchdarkly-js-client-sdk");
const utils_1 = require("./utils");
const packageInfo = __importStar(require("../package.json"));
const wrapperOptions = {
    wrapperName: 'react-client-sdk',
    wrapperVersion: packageInfo.version,
    sendEventsOnlyForVariation: true,
};
/**
 * Internal function to initialize the `LDClient`.
 *
 * @param clientSideID Your project and environment specific client side ID
 * @param user A LaunchDarkly user object
 * @param options LaunchDarkly initialization options
 * @param targetFlags If specified, `launchdarkly-react-client-sdk` will only request and listen to these flags.
 * Flag keys must be in their original form as known to LaunchDarkly rather than in their camel-cased form.
 *
 * @see `ProviderConfig` for more details about the parameters
 * @return An initialized client and flags
 */
const initLDClient = (clientSideID, user = { anonymous: true }, options, targetFlags) => __awaiter(void 0, void 0, void 0, function* () {
    const ldClient = (0, launchdarkly_js_client_sdk_1.initialize)(clientSideID, user, Object.assign(Object.assign({}, wrapperOptions), options));
    return new Promise((resolve) => {
        function cleanup() {
            ldClient.off('ready', handleReady);
            ldClient.off('failed', handleFailure);
        }
        function handleFailure(error) {
            cleanup();
            resolve({ flags: {}, ldClient, error });
        }
        function handleReady() {
            cleanup();
            const flags = (0, utils_1.fetchFlags)(ldClient, targetFlags);
            resolve({ flags, ldClient });
        }
        ldClient.on('failed', handleFailure);
        ldClient.on('ready', handleReady);
    });
});
exports.default = initLDClient;
//# sourceMappingURL=initLDClient.js.map