"use strict";

var isError = require('iserror'); // we want to support parsing other fields than the standard:
// <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors>
// <https://github.com/stripe/stripe-node/blob/3c07d851cf897490d8b93dd4457dda0c4c8e667f/lib/Error.js#L33>


var parseErr = function parseErr(err) {
  var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  if (!isError(err)) throw new Error('`err` must be an Error');
  if (!Array.isArray(fields)) throw new Error('`fields` must be an Array');
  var keys = {};
  Object.getOwnPropertyNames(Object.getPrototypeOf(err)).concat(Object.getOwnPropertyNames(err)).forEach(function (key) {
    if (typeof err[key] !== 'function') keys[key] = err[key];
  });
  if (!keys.name && err.constructor.name) keys.name = err.constructor.name;
  return Array.isArray(fields) && fields.length !== 0 ? keys.filter(function (key) {
    return fields.includes(key);
  }) : keys;
};

module.exports = parseErr;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC5qcyJdLCJuYW1lcyI6WyJpc0Vycm9yIiwicmVxdWlyZSIsInBhcnNlRXJyIiwiZXJyIiwiZmllbGRzIiwiRXJyb3IiLCJBcnJheSIsImlzQXJyYXkiLCJrZXlzIiwiT2JqZWN0IiwiZ2V0T3duUHJvcGVydHlOYW1lcyIsImdldFByb3RvdHlwZU9mIiwiY29uY2F0IiwiZm9yRWFjaCIsImtleSIsIm5hbWUiLCJjb25zdHJ1Y3RvciIsImxlbmd0aCIsImZpbHRlciIsImluY2x1ZGVzIiwibW9kdWxlIiwiZXhwb3J0cyJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxJQUFNQSxPQUFPLEdBQUdDLE9BQU8sQ0FBQyxTQUFELENBQXZCLEMsQ0FFQTtBQUNBO0FBQ0E7OztBQUNBLElBQU1DLFFBQVEsR0FBRyxTQUFYQSxRQUFXLENBQUNDLEdBQUQsRUFBc0I7QUFBQSxNQUFoQkMsTUFBZ0IsdUVBQVAsRUFBTztBQUNyQyxNQUFJLENBQUNKLE9BQU8sQ0FBQ0csR0FBRCxDQUFaLEVBQW1CLE1BQU0sSUFBSUUsS0FBSixDQUFVLHdCQUFWLENBQU47QUFDbkIsTUFBSSxDQUFDQyxLQUFLLENBQUNDLE9BQU4sQ0FBY0gsTUFBZCxDQUFMLEVBQTRCLE1BQU0sSUFBSUMsS0FBSixDQUFVLDJCQUFWLENBQU47QUFFNUIsTUFBTUcsSUFBSSxHQUFHLEVBQWI7QUFDQUMsRUFBQUEsTUFBTSxDQUFDQyxtQkFBUCxDQUEyQkQsTUFBTSxDQUFDRSxjQUFQLENBQXNCUixHQUF0QixDQUEzQixFQUNHUyxNQURILENBQ1VILE1BQU0sQ0FBQ0MsbUJBQVAsQ0FBMkJQLEdBQTNCLENBRFYsRUFFR1UsT0FGSCxDQUVXLFVBQUFDLEdBQUcsRUFBSTtBQUNkLFFBQUksT0FBT1gsR0FBRyxDQUFDVyxHQUFELENBQVYsS0FBb0IsVUFBeEIsRUFBb0NOLElBQUksQ0FBQ00sR0FBRCxDQUFKLEdBQVlYLEdBQUcsQ0FBQ1csR0FBRCxDQUFmO0FBQ3JDLEdBSkg7QUFNQSxNQUFJLENBQUNOLElBQUksQ0FBQ08sSUFBTixJQUFjWixHQUFHLENBQUNhLFdBQUosQ0FBZ0JELElBQWxDLEVBQXdDUCxJQUFJLENBQUNPLElBQUwsR0FBWVosR0FBRyxDQUFDYSxXQUFKLENBQWdCRCxJQUE1QjtBQUV4QyxTQUFPVCxLQUFLLENBQUNDLE9BQU4sQ0FBY0gsTUFBZCxLQUF5QkEsTUFBTSxDQUFDYSxNQUFQLEtBQWtCLENBQTNDLEdBQ0hULElBQUksQ0FBQ1UsTUFBTCxDQUFZLFVBQUFKLEdBQUc7QUFBQSxXQUFJVixNQUFNLENBQUNlLFFBQVAsQ0FBZ0JMLEdBQWhCLENBQUo7QUFBQSxHQUFmLENBREcsR0FFSE4sSUFGSjtBQUdELENBaEJEOztBQWtCQVksTUFBTSxDQUFDQyxPQUFQLEdBQWlCbkIsUUFBakIiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBpc0Vycm9yID0gcmVxdWlyZSgnaXNlcnJvcicpO1xuXG4vLyB3ZSB3YW50IHRvIHN1cHBvcnQgcGFyc2luZyBvdGhlciBmaWVsZHMgdGhhbiB0aGUgc3RhbmRhcmQ6XG4vLyA8aHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvSmF2YVNjcmlwdC9SZWZlcmVuY2UvRXJyb3JzPlxuLy8gPGh0dHBzOi8vZ2l0aHViLmNvbS9zdHJpcGUvc3RyaXBlLW5vZGUvYmxvYi8zYzA3ZDg1MWNmODk3NDkwZDhiOTNkZDQ0NTdkZGEwYzRjOGU2NjdmL2xpYi9FcnJvci5qcyNMMzM+XG5jb25zdCBwYXJzZUVyciA9IChlcnIsIGZpZWxkcyA9IFtdKSA9PiB7XG4gIGlmICghaXNFcnJvcihlcnIpKSB0aHJvdyBuZXcgRXJyb3IoJ2BlcnJgIG11c3QgYmUgYW4gRXJyb3InKTtcbiAgaWYgKCFBcnJheS5pc0FycmF5KGZpZWxkcykpIHRocm93IG5ldyBFcnJvcignYGZpZWxkc2AgbXVzdCBiZSBhbiBBcnJheScpO1xuXG4gIGNvbnN0IGtleXMgPSB7fTtcbiAgT2JqZWN0LmdldE93blByb3BlcnR5TmFtZXMoT2JqZWN0LmdldFByb3RvdHlwZU9mKGVycikpXG4gICAgLmNvbmNhdChPYmplY3QuZ2V0T3duUHJvcGVydHlOYW1lcyhlcnIpKVxuICAgIC5mb3JFYWNoKGtleSA9PiB7XG4gICAgICBpZiAodHlwZW9mIGVycltrZXldICE9PSAnZnVuY3Rpb24nKSBrZXlzW2tleV0gPSBlcnJba2V5XTtcbiAgICB9KTtcblxuICBpZiAoIWtleXMubmFtZSAmJiBlcnIuY29uc3RydWN0b3IubmFtZSkga2V5cy5uYW1lID0gZXJyLmNvbnN0cnVjdG9yLm5hbWU7XG5cbiAgcmV0dXJuIEFycmF5LmlzQXJyYXkoZmllbGRzKSAmJiBmaWVsZHMubGVuZ3RoICE9PSAwXG4gICAgPyBrZXlzLmZpbHRlcihrZXkgPT4gZmllbGRzLmluY2x1ZGVzKGtleSkpXG4gICAgOiBrZXlzO1xufTtcblxubW9kdWxlLmV4cG9ydHMgPSBwYXJzZUVycjtcbiJdfQ==