'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = require('lodash.debounce');

var _lodash2 = _interopRequireDefault(_lodash);

var _autoprefix = require('./autoprefix');

var _autoprefix2 = _interopRequireDefault(_autoprefix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function autoprefixes(styles) {
  return Object.keys(styles).reduce(function (obj, key) {
    return obj[key] = (0, _autoprefix2.default)(styles[key]), obj;
  }, {});
}

var styles = autoprefixes({
  wrapper: {
    position: 'fixed',
    width: 0,
    height: 0,
    top: 0,
    left: 0
  },

  dim: {
    position: 'fixed',
    left: 0,
    right: 0,
    top: 0,
    bottom: 0,
    zIndex: 0,
    background: 'rgba(0, 0, 0, 0.2)',
    opacity: 1
  },

  dimAppear: {
    opacity: 0
  },

  dimTransparent: {
    pointerEvents: 'none'
  },

  dimHidden: {
    opacity: 0
  },

  dock: {
    position: 'fixed',
    zIndex: 1,
    boxShadow: '0 0 4px rgba(0, 0, 0, 0.3)',
    background: 'white',
    left: 0,
    top: 0,
    width: '100%',
    height: '100%'
  },

  dockHidden: {
    opacity: 0
  },

  dockResizing: {
    transition: 'none'
  },

  dockContent: {
    width: '100%',
    height: '100%',
    overflow: 'auto'
  },

  resizer: {
    position: 'absolute',
    zIndex: 2,
    opacity: 0
  }
});

function getTransitions(duration) {
  return ['left', 'top', 'width', 'height'].map(function (p) {
    return p + ' ' + duration / 1000 + 's ease-out';
  });
}

function getDockStyles(_ref, _ref2) {
  var fluid = _ref.fluid;
  var dockStyle = _ref.dockStyle;
  var dockHiddenStyle = _ref.dockHiddenStyle;
  var duration = _ref.duration;
  var position = _ref.position;
  var isVisible = _ref.isVisible;
  var size = _ref2.size;
  var isResizing = _ref2.isResizing;
  var fullWidth = _ref2.fullWidth;
  var fullHeight = _ref2.fullHeight;

  var posStyle = void 0;
  var absSize = fluid ? size * 100 + '%' : size + 'px';

  function getRestSize(fullSize) {
    return fluid ? 100 - size * 100 + '%' : fullSize - size + 'px';
  }

  switch (position) {
    case 'left':
      posStyle = {
        width: absSize,
        left: isVisible ? 0 : '-' + absSize
      };
      break;
    case 'right':
      posStyle = {
        left: isVisible ? getRestSize(fullWidth) : fullWidth,
        width: absSize
      };
      break;
    case 'top':
      posStyle = {
        top: isVisible ? 0 : '-' + absSize,
        height: absSize
      };
      break;
    case 'bottom':
      posStyle = {
        top: isVisible ? getRestSize(fullHeight) : fullHeight,
        height: absSize
      };
      break;
  }

  var transitions = getTransitions(duration);

  return [styles.dock, (0, _autoprefix2.default)({
    transition: [].concat(_toConsumableArray(transitions), [!isVisible && 'opacity 0.01s linear ' + duration / 1000 + 's']).filter(function (t) {
      return t;
    }).join(',')
  }), dockStyle, (0, _autoprefix2.default)(posStyle), isResizing && styles.dockResizing, !isVisible && styles.dockHidden, !isVisible && dockHiddenStyle];
}

function getDimStyles(_ref3, _ref4) {
  var dimMode = _ref3.dimMode;
  var dimStyle = _ref3.dimStyle;
  var duration = _ref3.duration;
  var isVisible = _ref3.isVisible;
  var isTransitionStarted = _ref4.isTransitionStarted;

  return [styles.dim, (0, _autoprefix2.default)({
    transition: 'opacity ' + duration / 1000 + 's ease-out'
  }), dimStyle, dimMode === 'transparent' && styles.dimTransparent, !isVisible && styles.dimHidden, isTransitionStarted && isVisible && styles.dimAppear, isTransitionStarted && !isVisible && styles.dimDisappear];
}

function getResizerStyles(position) {
  var resizerStyle = void 0;
  var size = 10;

  switch (position) {
    case 'left':
      resizerStyle = {
        right: -size / 2,
        width: size,
        top: 0,
        height: '100%',
        cursor: 'col-resize'
      };
      break;
    case 'right':
      resizerStyle = {
        left: -size / 2,
        width: size,
        top: 0,
        height: '100%',
        cursor: 'col-resize'
      };
      break;
    case 'top':
      resizerStyle = {
        bottom: -size / 2,
        height: size,
        left: 0,
        width: '100%',
        cursor: 'row-resize'
      };
      break;
    case 'bottom':
      resizerStyle = {
        top: -size / 2,
        height: size,
        left: 0,
        width: '100%',
        cursor: 'row-resize'
      };
      break;
  }

  return [styles.resizer, (0, _autoprefix2.default)(resizerStyle)];
}

function getFullSize(position, fullWidth, fullHeight) {
  return position === 'left' || position === 'right' ? fullWidth : fullHeight;
}

var Dock = (_temp = _class = function (_Component) {
  _inherits(Dock, _Component);

  function Dock(props) {
    _classCallCheck(this, Dock);

    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Dock).call(this, props));

    _this.transitionEnd = function () {
      _this.setState({ isTransitionStarted: false });
    };

    _this.hideDim = function () {
      if (!_this.props.isVisible) {
        _this.setState({ isDimHidden: true });
      }
    };

    _this.handleDimClick = function () {
      if (_this.props.dimMode === 'opaque') {
        _this.props.onVisibleChange && _this.props.onVisibleChange(false);
      }
    };

    _this.handleResize = function () {
      if (window.requestAnimationFrame) {
        window.requestAnimationFrame(_this.updateWindowSize.bind(_this, true));
      } else {
        _this.updateWindowSize(true);
      }
    };

    _this.updateWindowSize = function (windowResize) {
      var sizeState = {
        fullWidth: window.innerWidth,
        fullHeight: window.innerHeight
      };

      if (windowResize) {
        _this.setState(_extends({}, sizeState, {
          isResizing: true,
          isWindowResizing: windowResize
        }));

        _this.debouncedUpdateWindowSizeEnd();
      } else {
        _this.setState(sizeState);
      }
    };

    _this.updateWindowSizeEnd = function () {
      _this.setState({
        isResizing: false,
        isWindowResizing: false
      });
    };

    _this.debouncedUpdateWindowSizeEnd = (0, _lodash2.default)(_this.updateWindowSizeEnd, 30);

    _this.handleWrapperLeave = function () {
      _this.setState({ isResizing: false });
    };

    _this.handleMouseDown = function () {
      _this.setState({ isResizing: true });
    };

    _this.handleMouseUp = function () {
      _this.setState({ isResizing: false });
    };

    _this.handleMouseMove = function (e) {
      if (!_this.state.isResizing || _this.state.isWindowResizing) return;
      e.preventDefault();

      var _this$props = _this.props;
      var position = _this$props.position;
      var fluid = _this$props.fluid;
      var _this$state = _this.state;
      var fullWidth = _this$state.fullWidth;
      var fullHeight = _this$state.fullHeight;
      var isControlled = _this$state.isControlled;
      var x = e.clientX;
      var y = e.clientY;

      var size = void 0;

      switch (position) {
        case 'left':
          size = fluid ? x / fullWidth : x;
          break;
        case 'right':
          size = fluid ? (fullWidth - x) / fullWidth : fullWidth - x;
          break;
        case 'top':
          size = fluid ? y / fullHeight : y;
          break;
        case 'bottom':
          size = fluid ? (fullHeight - y) / fullHeight : fullHeight - y;
          break;
      }

      _this.props.onSizeChange && _this.props.onSizeChange(size);

      if (!isControlled) {
        _this.setState({ size: size });
      }
    };

    _this.state = {
      isControlled: typeof props.size !== 'undefined',
      size: props.size || props.defaultSize,
      isDimHidden: !props.isVisible,
      fullWidth: typeof window !== 'undefined' && window.innerWidth,
      fullHeight: typeof window !== 'undefined' && window.innerHeight,
      isTransitionStarted: false,
      isWindowResizing: false
    };
    return _this;
  }

  _createClass(Dock, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      window.addEventListener('mouseup', this.handleMouseUp);
      window.addEventListener('mousemove', this.handleMouseMove);
      window.addEventListener('resize', this.handleResize);

      if (!window.fullWidth) {
        this.updateWindowSize();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      window.removeEventListener('mouseup', this.handleMouseUp);
      window.removeEventListener('mousemove', this.handleMouseMove);
      window.removeEventListener('resize', this.handleResize);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var isControlled = typeof nextProps.size !== 'undefined';

      this.setState({ isControlled: isControlled });

      if (isControlled && this.props.size !== nextProps.size) {
        this.setState({ size: nextProps.size });
      } else if (this.props.fluid !== nextProps.fluid) {
        this.updateSize(nextProps);
      }

      if (this.props.isVisible !== nextProps.isVisible) {
        this.setState({
          isTransitionStarted: true
        });
      }
    }
  }, {
    key: 'updateSize',
    value: function updateSize(props) {
      var _state = this.state;
      var fullWidth = _state.fullWidth;
      var fullHeight = _state.fullHeight;


      this.setState({
        size: props.fluid ? this.state.size / getFullSize(props.position, fullWidth, fullHeight) : getFullSize(props.position, fullWidth, fullHeight) * this.state.size
      });
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      var _this2 = this;

      if (this.props.isVisible !== prevProps.isVisible) {
        if (!this.props.isVisible) {
          window.setTimeout(function () {
            return _this2.hideDim();
          }, this.props.duration);
        } else {
          this.setState({ isDimHidden: false });
        }

        window.setTimeout(function () {
          return _this2.setState({ isTransitionStarted: false });
        }, 0);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props;
      var children = _props.children;
      var zIndex = _props.zIndex;
      var dimMode = _props.dimMode;
      var position = _props.position;
      var isVisible = _props.isVisible;
      var _state2 = this.state;
      var isResizing = _state2.isResizing;
      var size = _state2.size;
      var isDimHidden = _state2.isDimHidden;


      var dimStyles = Object.assign.apply(Object, [{}].concat(_toConsumableArray(getDimStyles(this.props, this.state))));
      var dockStyles = Object.assign.apply(Object, [{}].concat(_toConsumableArray(getDockStyles(this.props, this.state))));
      var resizerStyles = Object.assign.apply(Object, [{}].concat(_toConsumableArray(getResizerStyles(position))));

      return _react2.default.createElement(
        'div',
        { style: Object.assign({}, styles.wrapper, { zIndex: zIndex }) },
        dimMode !== 'none' && !isDimHidden && _react2.default.createElement('div', { style: dimStyles, onClick: this.handleDimClick }),
        _react2.default.createElement(
          'div',
          { style: dockStyles },
          _react2.default.createElement('div', { style: resizerStyles,
            onMouseDown: this.handleMouseDown }),
          _react2.default.createElement(
            'div',
            { style: styles.dockContent },
            typeof children === 'function' ? children({
              position: position,
              isResizing: isResizing,
              size: size,
              isVisible: isVisible
            }) : children
          )
        )
      );
    }
  }]);

  return Dock;
}(_react.Component), _class.propTypes = {
  position: _propTypes2.default.oneOf(['left', 'right', 'top', 'bottom']),
  zIndex: _propTypes2.default.number,
  fluid: _propTypes2.default.bool,
  size: _propTypes2.default.number,
  defaultSize: _propTypes2.default.number,
  dimMode: _propTypes2.default.oneOf(['none', 'transparent', 'opaque']),
  isVisible: _propTypes2.default.bool,
  onVisibleChange: _propTypes2.default.func,
  onSizeChange: _propTypes2.default.func,
  dimStyle: _propTypes2.default.object,
  dockStyle: _propTypes2.default.object,
  duration: _propTypes2.default.number
}, _class.defaultProps = {
  position: 'left',
  zIndex: 99999999,
  fluid: true,
  defaultSize: 0.3,
  dimMode: 'opaque',
  duration: 200
}, _temp);
exports.default = Dock;