import NonPrintableKeysDictionary from '../../const/NonPrintableKeysDictionary';
/**
 * Whether the specified key is a valid key name that is not a single character or
 * symbol
 * @param {ReactKeyName} keyName Name of the key
 * @returns {boolean} Whether the key is a valid special key
 */

function isNonPrintableKeyName(keyName) {
  return !!NonPrintableKeysDictionary[keyName];
}

export default isNonPrintableKeyName;