## [0.32.9](https://github.com/jquense/yup/compare/v0.32.6...v0.32.9) (2021-02-17)


### Bug Fixes

* **types:** Array required() and defined() will no longer return any ([#1256](https://github.com/jquense/yup/issues/1256)) ([52e5876](https://github.com/jquense/yup/commit/52e5876))
* export MixedSchema to fix ts with --declarations ([#1204](https://github.com/jquense/yup/issues/1204)) ([67c96ae](https://github.com/jquense/yup/commit/67c96ae))
* **types:** add generic to Reference.create() ([#1208](https://github.com/jquense/yup/issues/1208)) ([be3d1b4](https://github.com/jquense/yup/commit/be3d1b4))
* **types:** reach and getIn make last 2 arguments optional ([#1194](https://github.com/jquense/yup/issues/1194)) ([5cf2c48](https://github.com/jquense/yup/commit/5cf2c48))
* do not initialize spec values with undefined ([#1177](https://github.com/jquense/yup/issues/1177)) ([e8e5b46](https://github.com/jquense/yup/commit/e8e5b46)), closes [jquense/yup#1160](https://github.com/jquense/yup/issues/1160) [jquense/yup#1160](https://github.com/jquense/yup/issues/1160)
* **types:** meta() return type ([e41040a](https://github.com/jquense/yup/commit/e41040a))
* array handling in SchemaOf type ([#1169](https://github.com/jquense/yup/issues/1169)) ([e785e1a](https://github.com/jquense/yup/commit/e785e1a))
* **types:** make StringSchema.matches options optional ([#1166](https://github.com/jquense/yup/issues/1166)) ([b53e5f2](https://github.com/jquense/yup/commit/b53e5f2))
* **types:** SchemaOf doesn't produce a union of base schema ([2d71f32](https://github.com/jquense/yup/commit/2d71f32))





## [0.32.6](https://github.com/jquense/yup/compare/v0.32.5...v0.32.6) (2020-12-08)


### Bug Fixes

* mixed() is the the base class ([7f8591d](https://github.com/jquense/yup/commit/7f8591d)), closes [#1156](https://github.com/jquense/yup/issues/1156)





## [0.32.5](https://github.com/jquense/yup/compare/v0.32.4...v0.32.5) (2020-12-07)


### Bug Fixes

* **types:** change base.default() to any ([01c6930](https://github.com/jquense/yup/commit/01c6930))





## [0.32.4](https://github.com/jquense/yup/compare/v0.32.3...v0.32.4) (2020-12-07)


### Bug Fixes

* **types:** rm base pick/omit types as they conflict with more specific ones ([14e2c8c](https://github.com/jquense/yup/commit/14e2c8c))


### Features

* add additional functions to Lazy class ([#1148](https://github.com/jquense/yup/issues/1148)) ([ecad1a3](https://github.com/jquense/yup/commit/ecad1a3))





## [0.32.3](https://github.com/jquense/yup/compare/v0.32.2...v0.32.3) (2020-12-07)


### Bug Fixes

* **types:** AnyObjectSchema anys ([1c54665](https://github.com/jquense/yup/commit/1c54665))





## [0.32.2](https://github.com/jquense/yup/compare/v0.32.1...v0.32.2) (2020-12-07)


### Bug Fixes

* **types:** array type with lazy ([ba92dfc](https://github.com/jquense/yup/commit/ba92dfc)), closes [#1146](https://github.com/jquense/yup/issues/1146)





## [0.32.1](https://github.com/jquense/yup/compare/v0.32.0...v0.32.1) (2020-12-04)


### Bug Fixes

* cyclical import ([d5c5391](https://github.com/jquense/yup/commit/d5c5391)), closes [#1138](https://github.com/jquense/yup/issues/1138)
* some strict fn type improvements ([8092218](https://github.com/jquense/yup/commit/8092218))





# [0.32.0](https://github.com/jquense/yup/compare/v0.31.1...v0.32.0) (2020-12-03)


### Features

* typescript support ([#1134](https://github.com/jquense/yup/issues/1134)) ([b97c39d](https://github.com/jquense/yup/commit/b97c39d))


### BREAKING CHANGES

* `concat` doesn't check for "unset" nullable or presence when merging meaning the nullability and presence will always be the same as the schema passed to `concat()`. They can be overridden if needed after concatenation
* schema factory functions are no longer constructors. The classes are now also exported for extension or whatever else. e.g. `import { StringSchema, string } from 'yup'`





## [0.31.1](https://github.com/jquense/yup/compare/v0.31.0...v0.31.1) (2020-12-01)


### Bug Fixes

* swallowed errors on nested schema with no tests ([5316ab9](https://github.com/jquense/yup/commit/5316ab9)), closes [#1127](https://github.com/jquense/yup/issues/1127)


### Features

* add `isTrue` and `isFalse` checks on boolean ([#910](https://github.com/jquense/yup/issues/910)) ([630a641](https://github.com/jquense/yup/commit/630a641))





# [0.31.0](https://github.com/jquense/yup/compare/v0.30.0...v0.31.0) (2020-11-23)


### Bug Fixes

* path params incorrectly mutated ([ba23eb7](https://github.com/jquense/yup/commit/ba23eb7)), closes [#1122](https://github.com/jquense/yup/issues/1122)


### Features

* add array.length() and treat empty arrays as valid for required() ([fbc158d](https://github.com/jquense/yup/commit/fbc158d))
* add object.pick and object.omit ([425705a](https://github.com/jquense/yup/commit/425705a))
* deprecate the getter overload of `default()` ([#1119](https://github.com/jquense/yup/issues/1119)) ([5dae837](https://github.com/jquense/yup/commit/5dae837))
* more strictly coerce strings, exclude arrays and plain objects ([963d2e8](https://github.com/jquense/yup/commit/963d2e8))


### BREAKING CHANGES

* array().required() will no longer consider an empty array missing and required checks will pass.

To maintain the old behavior change to:
```js
array().required().min(1)
```
* plain objects and arrays are no long cast to strings automatically

to recreate the old behavior:
```js
string().transform((_, input) => input != null && input.toString ? input.toString() : value);
```





# [0.30.0](https://github.com/jquense/yup/compare/v0.29.3...v0.30.0) (2020-11-19)


### Bug Fixes

* defined() so it doesn't mark a schema as nullable ([f08d507](https://github.com/jquense/yup/commit/f08d507))
* IE11 clone() ([#1029](https://github.com/jquense/yup/issues/1029)) ([7fd80aa](https://github.com/jquense/yup/commit/7fd80aa))
* security Fix for Prototype Pollution - huntr.dev ([#1088](https://github.com/jquense/yup/issues/1088)) ([15a0f43](https://github.com/jquense/yup/commit/15a0f43))
* uuid's regexp ([#1112](https://github.com/jquense/yup/issues/1112)) ([57d42a8](https://github.com/jquense/yup/commit/57d42a8))


### Features

* exposes context on mixed.test function and add originalValue to context ([#1021](https://github.com/jquense/yup/issues/1021)) ([6096064](https://github.com/jquense/yup/commit/6096064))


### Performance Improvements

* reduce function calls for shallower stacks ([#1022](https://github.com/jquense/yup/issues/1022)) ([01da7e1](https://github.com/jquense/yup/commit/01da7e1))


### BREAKING CHANGES

* defined() now doesn't automatically allow null, this was a bug. to mimic the old behavior add nullable() to schema with defined()





## [0.29.3](https://github.com/jquense/yup/compare/v0.29.2...v0.29.3) (2020-08-04)





## [0.29.2](https://github.com/jquense/yup/compare/v0.29.1...v0.29.2) (2020-07-27)


### Bug Fixes

* handle sparse array positions as undefined ([#950](https://github.com/jquense/yup/issues/950)) ([4e77348](https://github.com/jquense/yup/commit/4e77348))


### Features

* string UUID validation via a regex ([#909](https://github.com/jquense/yup/issues/909)) ([8f2bd2b](https://github.com/jquense/yup/commit/8f2bd2b))





## [0.29.1](https://github.com/jquense/yup/compare/v0.29.0...v0.29.1) (2020-05-27)


### Bug Fixes

* present checks for array and strings ([ecd8ebe](https://github.com/jquense/yup/commit/ecd8ebe483456805d743c888a82e180394ba8a22)), closes [#913](https://github.com/jquense/yup/issues/913)


### Features

* allow access to parent schema (and unlimited ancestors!) in test context ([#556](https://github.com/jquense/yup/issues/556)) ([db35920](https://github.com/jquense/yup/commit/db35920b1ede4ea41ea90e1204b3da2a39787635))





# [0.29.0](https://github.com/jquense/yup/compare/v0.28.5...v0.29.0) (2020-05-19)


* feat!: update docs to account for changes in types and add additional example (#891) ([e105a71](https://github.com/jquense/yup/commit/e105a71)), closes [#891](https://github.com/jquense/yup/issues/891)


### Bug Fixes

* object bug when nested object has a property with strict ([#871](https://github.com/jquense/yup/issues/871)) ([7f52b8a](https://github.com/jquense/yup/commit/7f52b8a))


### Features

* expose oneOf and notOneOf values on description ([#885](https://github.com/jquense/yup/issues/885)) ([08dad5f](https://github.com/jquense/yup/commit/08dad5f))


### BREAKING CHANGES

* For users of `@types/yup` only, no function changes but the type def change is large enough that it warranted a major bump here





## [0.28.5](https://github.com/jquense/yup/compare/v0.28.4...v0.28.5) (2020-04-30)

### Bug Fixes

- allow passing of function to .matches() options/message param ([#850](https://github.com/jquense/yup/issues/850)) ([16efe88](https://github.com/jquense/yup/commit/16efe88a8953db60438f77f43bd5bf614079803d))
- bug in object.noUnknown for nullish values https://github.com/jquense/yup/issues/854 ([#855](https://github.com/jquense/yup/issues/855)) ([ccb7c7d](https://github.com/jquense/yup/commit/ccb7c7d3c450537dffbb7d589e3111fc1f9a86fd))

## [0.28.4](https://github.com/jquense/yup/compare/v0.28.3...v0.28.4) (2020-04-20)

### Bug Fixes

- array reaching ([81e4058](https://github.com/jquense/yup/commit/81e4058))

### Features

- make schema.type and array.innerType public API's ([8f00d50](https://github.com/jquense/yup/commit/8f00d50))
- provide keys in default noUnknown message ([#579](https://github.com/jquense/yup/issues/579)) ([ad5d015](https://github.com/jquense/yup/commit/ad5d015))

## [0.28.3](https://github.com/jquense/yup/compare/v0.28.2...v0.28.3) (2020-03-06)

### Bug Fixes

- array.ensure ([94659c2](https://github.com/jquense/yup/commit/94659c2)), closes [#343](https://github.com/jquense/yup/issues/343)
- match options ([493cc61](https://github.com/jquense/yup/commit/493cc61)), closes [#802](https://github.com/jquense/yup/issues/802) [#801](https://github.com/jquense/yup/issues/801) [#799](https://github.com/jquense/yup/issues/799) [#798](https://github.com/jquense/yup/issues/798)

# [0.28.0](https://github.com/jquense/yup/compare/v0.26.10...v0.28.0) (2019-12-16)

### Bug Fixes

- [#473](https://github.com/jquense/yup/issues/473) make concat compatible with (not)oneOf ([#492](https://github.com/jquense/yup/issues/492)) ([8d21cc9](https://github.com/jquense/yup/commit/8d21cc9))
- array path resolve for descendants ([#669](https://github.com/jquense/yup/issues/669)) ([d31e34d](https://github.com/jquense/yup/commit/d31e34d))
- change @babel/runtime version to be a range ([#488](https://github.com/jquense/yup/issues/488)) ([1c9b362](https://github.com/jquense/yup/commit/1c9b362)), closes [#486](https://github.com/jquense/yup/issues/486)
- concat of mixed and subtype ([#444](https://github.com/jquense/yup/issues/444)) ([7705972](https://github.com/jquense/yup/commit/7705972))
- default message for test with object ([#453](https://github.com/jquense/yup/issues/453)) ([f1be37f](https://github.com/jquense/yup/commit/f1be37f))
- noUnknown() overriding ([#452](https://github.com/jquense/yup/issues/452)) ([3047b33](https://github.com/jquense/yup/commit/3047b33))
- string.matches() and regex global flag ([#450](https://github.com/jquense/yup/issues/450)) ([a8935b7](https://github.com/jquense/yup/commit/a8935b7))
- synchronous conditional object validation with unknown dependencies ([#598](https://github.com/jquense/yup/issues/598)) ([1081c41](https://github.com/jquense/yup/commit/1081c41))
- typo README (about excludeEmptyString) ([#441](https://github.com/jquense/yup/issues/441)) ([d02ff5e](https://github.com/jquense/yup/commit/d02ff5e))
- unix epoc bug in date parser ([#655](https://github.com/jquense/yup/issues/655)) ([0d14827](https://github.com/jquense/yup/commit/0d14827))

### Features

- add \_isFilled as overrideable `mixed` method to control required behavior ([#459](https://github.com/jquense/yup/issues/459)) ([5b01f18](https://github.com/jquense/yup/commit/5b01f18))
- add function test names to email and url ([#292](https://github.com/jquense/yup/issues/292)) ([7e94395](https://github.com/jquense/yup/commit/7e94395))
- aliases `optional()` and `unknown()` ([#460](https://github.com/jquense/yup/issues/460)) ([51e8661](https://github.com/jquense/yup/commit/51e8661))
- allow toggling strict() ([#457](https://github.com/jquense/yup/issues/457)) ([851d421](https://github.com/jquense/yup/commit/851d421))
- allow withMutation() nesting ([#456](https://github.com/jquense/yup/issues/456)) ([e53ea8c](https://github.com/jquense/yup/commit/e53ea8c))
- do concat in mutation mode ([#461](https://github.com/jquense/yup/issues/461)) ([02be4ca](https://github.com/jquense/yup/commit/02be4ca))
- finalize resolve() ([#447](https://github.com/jquense/yup/issues/447)) ([afc5119](https://github.com/jquense/yup/commit/afc5119))
- replace integer check with Number.isInteger ([#405](https://github.com/jquense/yup/issues/405)) ([1c18442](https://github.com/jquense/yup/commit/1c18442))
- support self references ([#443](https://github.com/jquense/yup/issues/443)) ([1cac515](https://github.com/jquense/yup/commit/1cac515)), closes [/github.com/jquense/yup/blob/d02ff5e59e004b4c5189d1b9fc0055cff45c61df/src/Reference.js#L3](https://github.com//github.com/jquense/yup/blob/d02ff5e59e004b4c5189d1b9fc0055cff45c61df/src/Reference.js/issues/L3)
- use the alternate object index path syntax if the key contains dots (fixes [#536](https://github.com/jquense/yup/issues/536)) ([#539](https://github.com/jquense/yup/issues/539)) ([13e8c76](https://github.com/jquense/yup/commit/13e8c76))

### BREAKING CHANGES

- use Number.isInteger. This works correctly for large numbers.

Related to https://github.com/jquense/yup/pull/147

- reach() no longer resolves the returned schema meaning it's conditions have not been processed yet; prefer validateAt/castAt where it makes sense
- required no longer shows up twice in describe() output for array and strings, which also no longer override required

# [0.27.0](https://github.com/jquense/yup/compare/v0.26.10...v0.27.0) (2019-03-14)

### Bug Fixes

- change @babel/runtime version to be a range ([#488](https://github.com/jquense/yup/issues/488)) ([1c9b362](https://github.com/jquense/yup/commit/1c9b362)), closes [#486](https://github.com/jquense/yup/issues/486)
- concat of mixed and subtype ([#444](https://github.com/jquense/yup/issues/444)) ([7705972](https://github.com/jquense/yup/commit/7705972))
- default message for test with object ([#453](https://github.com/jquense/yup/issues/453)) ([f1be37f](https://github.com/jquense/yup/commit/f1be37f))
- noUnknown() overriding ([#452](https://github.com/jquense/yup/issues/452)) ([3047b33](https://github.com/jquense/yup/commit/3047b33))
- typo README (about excludeEmptyString) ([#441](https://github.com/jquense/yup/issues/441)) ([d02ff5e](https://github.com/jquense/yup/commit/d02ff5e))

### Features

- add \_isFilled as overrideable `mixed` method to control required behavior ([#459](https://github.com/jquense/yup/issues/459)) ([5b01f18](https://github.com/jquense/yup/commit/5b01f18))
- aliases `optional()` and `unknown()` ([#460](https://github.com/jquense/yup/issues/460)) ([51e8661](https://github.com/jquense/yup/commit/51e8661))
- allow toggling strict() ([#457](https://github.com/jquense/yup/issues/457)) ([851d421](https://github.com/jquense/yup/commit/851d421))
- allow withMutation() nesting ([#456](https://github.com/jquense/yup/issues/456)) ([e53ea8c](https://github.com/jquense/yup/commit/e53ea8c))
- do concat in mutation mode ([#461](https://github.com/jquense/yup/issues/461)) ([02be4ca](https://github.com/jquense/yup/commit/02be4ca))
- finalize resolve() ([#447](https://github.com/jquense/yup/issues/447)) ([afc5119](https://github.com/jquense/yup/commit/afc5119))
- support self references ([#443](https://github.com/jquense/yup/issues/443)) ([1cac515](https://github.com/jquense/yup/commit/1cac515)), closes [/github.com/jquense/yup/blob/d02ff5e59e004b4c5189d1b9fc0055cff45c61df/src/Reference.js#L3](https://github.com//github.com/jquense/yup/blob/d02ff5e59e004b4c5189d1b9fc0055cff45c61df/src/Reference.js/issues/L3)

### BREAKING CHANGES

- reach() no longer resolves the returned schema meaning it's conditions have not been processed yet; prefer validateAt/castAt where it makes sense
- required no longer shows up twice in describe() output for array and strings, which also no longer override required

## v0.26.3 - Tue, 28 Aug 2018 15:00:04 GMT

## v0.26.0 - Fri, 20 Jul 2018 15:39:03 GMT

### BREAKING CHANGES

- locale `number` config properties `less` and `more` are now `lessThan` and `moreThan`

## v0.25.1 - Wed, 16 May 2018 23:59:14 GMT

## v0.25.0 - Tue, 15 May 2018 21:43:54 GMT

- remove default export, there are only named exports now!
- fix message defaults for built-in tests, default is only used for `undefined` messages
- fix the `describe()` method so it works with nested schemas

## v0.24.1 - Fri, 09 Feb 2018 19:09:02 GMT

## v0.24.0 - Tue, 16 Jan 2018 14:44:32 GMT

- [f2a0b75](../../commit/f2a0b75), [061e590](../../commit/061e590) [added] number methods lessThan, moreThan

## v0.23.0 - Thu, 12 Oct 2017 17:08:47 GMT

** Probably not breaking but we are being safe about it **

- 🎉 Add Synchronous validation! [#94](https://github.com/jquense/yup/pull/94)

** Features **

- Custom locales without import order [#125](https://github.com/jquense/yup/pull/125)

## v0.22.1 - Thu, 12 Oct 2017 14:49:16 GMT

- Fix bug in browsers without symbol [#132](https://github.com/jquense/yup/pull/132)

## v0.22.0 - Sat, 26 Aug 2017 14:48:57 GMT

** Breaking **

- Use native Set and lodash CloneDeep: [#109](https://github.com/jquense/yup/pull/109)

\*\* Fixes and Features

- Better custom locale support: [#105](https://github.com/jquense/yup/pull/105)
- fix some messages: [#112](https://github.com/jquense/yup/pull/112)
- Clearer errors for common mistakes: [#108](https://github.com/jquense/yup/pull/108)
- New string validation length: [#67](https://github.com/jquense/yup/pull/67)

## v0.21.3 - Wed, 18 Jan 2017 15:39:25 GMT

- [7bc01e0](../../commit/7bc01e0) [added] deep path support for `from`

## v0.21.2 - Fri, 09 Sep 2016 16:52:44 GMT

- [be80413](../../commit/be80413) [fixed] default in concat()

## v0.21.1 - Mon, 29 Aug 2016 18:39:29 GMT

## v0.21.0 - Mon, 29 Aug 2016 18:29:31 GMT

- [8a8cc5b](../../commit/8a8cc5b) [changed] remove case aliases and simplify camelCase

## v0.20.0 - Wed, 20 Jul 2016 02:02:08 GMT

- [f7446d2](../../commit/f7446d2) [fixed] pass path correctly to cast()
- [9b5232a](../../commit/9b5232a) [added] allow function then/otherwise bodies
- [73858fe](../../commit/73858fe) [changed] Don't throw on undefined values in cast()

## v0.19.1 - Mon, 18 Jul 2016 21:53:05 GMT

- [69c0ad4](../../commit/69c0ad4) [fixed] array().concat() incorrectly cleared the sub-schema

## v0.19.0 - Fri, 24 Jun 2016 15:19:48 GMT

- [b0dd021](../../commit/b0dd021) [changed] Split integer(), remove transform
- [758ac51](../../commit/758ac51) [added] string.ensure
- [f2b0078](../../commit/f2b0078) [changed] Less aggressive type coercions
- [ab94510](../../commit/ab94510) [fixed] boxed number allowed NaN

## v0.18.3 - Mon, 09 May 2016 15:50:47 GMT

## v0.18.2 - Mon, 25 Apr 2016 18:23:13 GMT

## v0.18.1 - Mon, 25 Apr 2016 15:01:16 GMT

- [816e607](../../commit/816e607) [added] validation params to ValidationError

## v0.18.0 - Sat, 23 Apr 2016 01:20:27 GMT

- [f827822](../../commit/f827822) [changed] validate() on objects won't cast nested schema with strict()

## v0.17.6 - Thu, 21 Apr 2016 14:59:59 GMT

- [139dd24](../../commit/139dd24) [changed] lazy qualifies as a yup schema

## v0.17.5 - Thu, 21 Apr 2016 11:20:16 GMT

- [c553cc0](../../commit/c553cc0) [added] options to lazy resolve

## v0.17.4 - Wed, 20 Apr 2016 14:15:39 GMT

## v0.17.3 - Tue, 19 Apr 2016 20:24:09 GMT

- [6c309e4](../../commit/6c309e4) [fixed] array.ensure()

## v0.17.2 - Tue, 19 Apr 2016 16:46:54 GMT

## v0.17.1 - Thu, 14 Apr 2016 19:12:22 GMT

- [ab78f54](../../commit/ab78f54) [fixed] reach with lazy()

## v0.17.0 - Thu, 14 Apr 2016 17:13:50 GMT

- [6e9046b](../../commit/6e9046b) [changed] clean up interface, added lazy(), and fixed object strict semantics

## v0.16.5 - Tue, 12 Apr 2016 13:36:38 GMT

- [c3b613b](../../commit/c3b613b) [added] strip() method for objects
- [68fc010](../../commit/68fc010) [added] array.of shorthand

## v0.16.4 - Sat, 09 Apr 2016 20:13:13 GMT

- [f30d1e3](../../commit/f30d1e3) [fixed] bug in date min/max with ref

## v0.16.3 - Thu, 07 Apr 2016 19:13:23 GMT

## v0.16.2 - Thu, 07 Apr 2016 17:57:44 GMT

- [83c0656](../../commit/83c0656) [added] meta() and describe()

## v0.16.1 - Tue, 05 Apr 2016 20:56:45 GMT

- [9d70a7b](../../commit/9d70a7b) [changed] doesn't throw when context is missing.
- [594fa53](../../commit/594fa53) [changed] added reach error

## v0.16.0 - Tue, 05 Apr 2016 20:17:40 GMT

- [75739b8](../../commit/75739b8) [added] context sensitive reach()

## v0.15.0 - Tue, 29 Mar 2016 14:56:15 GMT

- [3ae5fdc](../../commit/3ae5fdc) [changed] `null` is not considered an empty value for isValid
- [9eb42c6](../../commit/9eb42c6) [added] refs!

## v0.14.2 - Tue, 29 Mar 2016 14:48:37 GMT

## v0.14.1 - Tue, 16 Feb 2016 19:51:25 GMT

- [ff19720](../../commit/ff19720) [fixed] noUnknown and stripUnknown work and propagate to children

## v0.14.0 - Mon, 08 Feb 2016 16:17:40 GMT

- [86b6446](../../commit/86b6446) [fixed] camelCase should maintain leading underscores

## v0.13.0 - Mon, 01 Feb 2016 20:49:40 GMT

- [335eb18](../../commit/335eb18) [fixed] pass options to array sub schema
- [f7f631d](../../commit/f7f631d) [changed] oneOf doesn't include empty values
- [0a7b2d4](../../commit/0a7b2d4) [fixed] type and whitelist/blacklist checks threw inconsistent errors
- [1274a45](../../commit/1274a45) [changed] required() to non-exclusive

## v0.12.0 - Tue, 12 Jan 2016 19:12:18 GMT

- [5bc250f](../../commit/5bc250f) [changed] don't clone unspecified object keys
- [069c6fd](../../commit/069c6fd) [added] withMutation() method
- [e1d4891](../../commit/e1d4891) [fixed] don't alias non existent fields

## v0.11.0 - Sun, 08 Nov 2015 17:17:09 GMT

- [686f6b1](../../commit/686f6b1) [changed] concat() allows mixing "mixed" and other type

## 0.9.0

**breaking**

- `test` functions are no longer passed `path` and `context` as arguments, Instead they are now values on `this` inside the test function.
- test functions are longer called with the schema as their `this` value, use `this.schema` instead.

**other changes**

- test functions are call with with a new context object, including, options, parent and `createError` for dynamically altering validation errors.

## 0.8.3

- document `stripUnknown`
- add `recursive` option
- add `noUnknown()` test to objects

## 0.8.2

- default for objects now adds keys for all fields, not just fields with non empty defaults

## 0.8.1

- bug fix

## 0.8.0

**breaking**

- `test` functions are now passed `path` and `context` values along with the field value. Only breaks if using the callback style of defining custom validations

## 0.7.0

**breaking**

- the `validation()` method has been renamed to `test()` and has a new signature requiring a `name` argument
- exclusive validations now trump the previous one instead of defering to it e.g: `string().max(10).max(15)` has a max of `15` instead of `10`

**other changes**

- expose advanced signature for custom validation tests, gives finer grained control over how tests are added
- added the `abortEarly` (default: `true`) option
- transforms are passed an addition parameter: 'originalValue' you allow recovering from a bad transform further up the chain (provided no one mutated the value)

## 0.6.3

- fix `concat()` method and add tests

## 0.6.2

- fix validations where nullable fields were failing due to `null` values e.g `string.max()`

## 0.6.1

- fix export error

## 0.6.0

**breaking**

- Removed the `extend` and `create` methods. Use whatever javascript inheritance patterns you want instead.
- the resolution order of defaults and coercions has changed. as well as the general handling of `null` values.
  - Number: `null` will coerce to `false` when `nullable()` is not specified. `NaN` values will now fail `isType()` checks
  - String: `null` will coerce to `''` when `nullable()` is not specified
  - Date: Invalid dates will not be coerced to `null`, but left as invalid date, This is probably not a problem for anyone as invalid dates will also fail `isType()` checks
- default values are cloned everytime they are returned, so it is impossible to share references to defaults across schemas. No one should be doing that anyway
- stopped pretending that using schemas as conditions in `when()` actually worked (it didn't)

**other changes**

- `transform()` now passes the original value to each transformer. Allowing you to recover from a bad transform.
- added the `equals()` alias for `oneOf`
-

## 0.5.0

**breaking**

- isValid is now async, provide a node style callback, or use the promise the method returns to read the validity. This change allows for more robust validations, specifically remote ones for client code (or db queries for server code). The cast method is still, and will remain, synchronous.
-

**other changes**

- added validate method (also async) which resolves to the value, and rejects with a new ValidationError
